/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.services;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import com.flybits.android.push.FlybitsNotificationManager;
import com.flybits.android.push.PushManager;
import com.flybits.android.push.analytics.PushAnalytics;
import com.flybits.android.push.models.Push;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import com.flybits.concierge.InternalPreferences;
import com.flybits.concierge.Utils;
import com.flybits.concierge.services.ConciergeIntentCreator;
import com.flybits.concierge.services.ConciergeMessagingService$Companion$WhenMappings;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0012\u0010\u0011\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H&\u00a8\u0006\u0016"}, d2={"Lcom/flybits/concierge/services/ConciergeMessagingService;", "Lcom/google/firebase/messaging/FirebaseMessagingService;", "Lcom/flybits/concierge/services/ConciergeIntentCreator;", "()V", "getNotificationIconRes", "", "onCreateIntent", "Landroid/content/Intent;", "push", "Lcom/flybits/android/push/models/Push;", "onCreatePendingIntent", "Landroid/app/PendingIntent;", "intent", "onMessageReceived", "", "remoteMessage", "Lcom/google/firebase/messaging/RemoteMessage;", "onNewToken", "recentToken", "", "onNonFlybitsPushReceived", "Companion", "concierge_release"})
public abstract class ConciergeMessagingService
extends FirebaseMessagingService
implements ConciergeIntentCreator {
    public static final Companion Companion = new Companion(null);

    public void onMessageReceived(@Nullable RemoteMessage remoteMessage) {
        super.onMessageReceived(remoteMessage);
        Logger.setTag((String)ConciergeMessagingService.class.getSimpleName()).d("onMessageReceived()");
        if (remoteMessage != null) {
            try {
                boolean success = com.flybits.concierge.services.ConciergeMessagingService$Companion.handleRemoteMessage$default(Companion, remoteMessage, (Context)this, this, this.getNotificationIconRes(), null, 16, null);
                if (!success) {
                    this.onNonFlybitsPushReceived(remoteMessage);
                }
            }
            catch (FlybitsException e) {
                Logger.exception((String)"ConciergeMessagingService.onMessageReceived()", (Exception)((Exception)((Object)e)));
            }
        }
    }

    public abstract void onNonFlybitsPushReceived(@NotNull RemoteMessage var1);

    public abstract int getNotificationIconRes();

    @Override
    @NotNull
    public PendingIntent onCreatePendingIntent(@NotNull Intent intent, @NotNull Push push) {
        Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
        Intrinsics.checkParameterIsNotNull((Object)push, (String)"push");
        Context context = this.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"applicationContext");
        return Companion.createPendingIntent(context, push, intent);
    }

    @Override
    @NotNull
    public Intent onCreateIntent(@NotNull Push push) {
        Intrinsics.checkParameterIsNotNull((Object)push, (String)"push");
        Context context = this.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"applicationContext");
        return Companion.createIntent(context, push);
    }

    public void onNewToken(@Nullable String recentToken) {
        super.onNewToken(recentToken);
        Logger.setTag((String)ConciergeMessagingService.class.getSimpleName()).d("onNewToken()");
        if (recentToken != null) {
            Companion.savePushToken(recentToken, (Context)this);
        }
    }

    @JvmStatic
    public static final boolean handleRemoteMessage(@NotNull RemoteMessage remoteMessage, @NotNull Context context, @NotNull ConciergeIntentCreator conciergeIntentCreator, int notificationIconRes, @NotNull PushAnalytics pushAnalytics) throws FlybitsException {
        return Companion.handleRemoteMessage(remoteMessage, context, conciergeIntentCreator, notificationIconRes, pushAnalytics);
    }

    @JvmStatic
    public static final void savePushToken(@NotNull String recentToken, @NotNull Context context) {
        Companion.savePushToken(recentToken, context);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\nJ2\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0007J\u0018\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u001c"}, d2={"Lcom/flybits/concierge/services/ConciergeMessagingService$Companion;", "", "()V", "broadcastIntent", "", "context", "Landroid/content/Context;", "action", "", "createIntent", "Landroid/content/Intent;", "push", "Lcom/flybits/android/push/models/Push;", "createPendingIntent", "Landroid/app/PendingIntent;", "intent", "handleRemoteMessage", "", "remoteMessage", "Lcom/google/firebase/messaging/RemoteMessage;", "conciergeIntentCreator", "Lcom/flybits/concierge/services/ConciergeIntentCreator;", "notificationIconRes", "", "pushAnalytics", "Lcom/flybits/android/push/analytics/PushAnalytics;", "savePushToken", "recentToken", "concierge_release"})
    public static final class Companion {
        @JvmStatic
        public final boolean handleRemoteMessage(@NotNull RemoteMessage remoteMessage, @NotNull Context context, @NotNull ConciergeIntentCreator conciergeIntentCreator, int notificationIconRes, @NotNull PushAnalytics pushAnalytics) throws FlybitsException {
            Push push;
            Intrinsics.checkParameterIsNotNull((Object)remoteMessage, (String)"remoteMessage");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)conciergeIntentCreator, (String)"conciergeIntentCreator");
            Intrinsics.checkParameterIsNotNull((Object)pushAnalytics, (String)"pushAnalytics");
            Map map = remoteMessage.getData();
            Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"remoteMessage.data");
            Push push2 = push = PushManager.parsePushNotification$default((Context)context, (Map)map, null, (int)4, null);
            if (push2 != null) {
                Push push3;
                Push it = push3 = push2;
                switch (ConciergeMessagingService$Companion$WhenMappings.$EnumSwitchMapping$0[it.getAction().ordinal()]) {
                    case 1: {
                        Companion.broadcastIntent(context, "flybits_con_broadcast_content_add");
                        break;
                    }
                    case 2: {
                        Companion.broadcastIntent(context, "flybits_con_broadcast_content_remove");
                        break;
                    }
                    case 3: {
                        Companion.broadcastIntent(context, "flybits_con_broadcast_content_update");
                        break;
                    }
                    case 4: {
                        Companion.broadcastIntent(context, "flybits_con_broadcast_rule_update");
                        break;
                    }
                    case 5: {
                        Companion.broadcastIntent(context, "flybits_con_broadcast_rule_state");
                        break;
                    }
                    case 6: {
                        FlybitsNotificationManager builder = new FlybitsNotificationManager.Simplifier(context, it.getId(), it.getTitle(), it.getMessage(), notificationIconRes).build();
                        Intent pushIntent = conciergeIntentCreator.onCreateIntent(push);
                        PendingIntent pendingIntent = conciergeIntentCreator.onCreatePendingIntent(pushIntent, push);
                        builder.get().setContentIntent(pendingIntent);
                        builder.show();
                        PushAnalytics.trackViewed$default((PushAnalytics)pushAnalytics, (Push)it, (long)0L, (int)2, null);
                        break;
                    }
                    default: {
                        throw (Throwable)new FlybitsException("Received unhandled flybits push notification action " + it.getAction());
                    }
                }
                return true;
            }
            return false;
        }

        @JvmStatic
        public static /* bridge */ /* synthetic */ boolean handleRemoteMessage$default(Companion companion, RemoteMessage remoteMessage, Context context, ConciergeIntentCreator conciergeIntentCreator, int n, PushAnalytics pushAnalytics, int n2, Object object) throws FlybitsException {
            if ((n2 & 0x10) != 0) {
                pushAnalytics = new PushAnalytics(context);
            }
            return companion.handleRemoteMessage(remoteMessage, context, conciergeIntentCreator, n, pushAnalytics);
        }

        @NotNull
        public final PendingIntent createPendingIntent(@NotNull Context context, @NotNull Push push, @NotNull Intent intent) throws FlybitsException {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)push, (String)"push");
            Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
            PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)push.getId().hashCode(), (Intent)intent, (int)0x8000000);
            Intrinsics.checkExpressionValueIsNotNull((Object)pendingIntent, (String)"PendingIntent.getActivit\u2026tent.FLAG_UPDATE_CURRENT)");
            return pendingIntent;
        }

        @NotNull
        public final Intent createIntent(@NotNull Context context, @NotNull Push push) throws FlybitsException {
            Intent intent;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)push, (String)"push");
            Class<Activity> clazz = Utils.launcherActivity(context);
            if (clazz == null) {
                throw (Throwable)new FlybitsException("No launcher activity found!");
            }
            Class<Activity> activityClass = clazz;
            Intent $receiver = intent = new Intent(context, activityClass);
            $receiver.setFlags(0x34000000);
            $receiver.putExtra("flybits_con_push_extra", (Parcelable)push);
            return intent;
        }

        @JvmStatic
        public final void savePushToken(@NotNull String recentToken, @NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)recentToken, (String)"recentToken");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            InternalPreferences.savePushToken(context, recentToken);
        }

        private final void broadcastIntent(Context context, String action) {
            Intent intent = new Intent();
            intent.setAction(action);
            context.sendBroadcast(intent);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

