package com.flybits.concierge.fragments;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Button;

import com.flybits.commons.library.logging.Logger;
import com.flybits.concierge.ConciergeConstants;
import com.flybits.concierge.FlybitsConcierge;
import com.flybits.concierge.R;

public class PrivacyPolicyFragment extends Fragment {

    private WebView webView;
    private View loadingView;
    private View errorView;
    private Button errorRetryButton;
    private boolean errorPresent = false;
    private String url;

    public static PrivacyPolicyFragment newInstance() {
        return new PrivacyPolicyFragment();
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.flybits_con_fragment_privacy_policy, container, false);

        return view;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {

        webView = view.findViewById(R.id.flybits_con_fragment_privacy_policy_web_view);
        loadingView = view.findViewById(R.id.flybits_con_settings_fragment_prgLoading);
        errorView = view.findViewById(R.id.flybits_con_fragment_privacy_policy_error_holder);
        errorRetryButton = view.findViewById(R.id.offline_fragment_retry_button);
        errorRetryButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Logger.d("retry button clicked!");
                if (url != null){
                    errorView.setVisibility(View.GONE);
                    loadWebView(url);
                }
            }
        });

        if (savedInstanceState == null) {

            url = FlybitsConcierge.with(getActivity()).getConfiguration().getPrivacyPolicyUrl();

            if (url != null) {
                loadWebView(url);
            }
        } else {
            webView.restoreState(savedInstanceState);
            errorPresent = savedInstanceState.getBoolean(ConciergeConstants.STATE_ERROR_PRESENT);
            url = savedInstanceState.getString(ConciergeConstants.STATE_URL);
            if (errorPresent){
                errorView.setVisibility(View.VISIBLE);
                webView.setVisibility(View.GONE);
            }else{
                errorView.setVisibility(View.GONE);
                webView.setVisibility(View.VISIBLE);
            }
        }
        super.onViewCreated(view, savedInstanceState);
    }

    private void loadWebView(String tncURL){
        errorPresent = false;
        webView.loadUrl(tncURL);
        webView.setVisibility(View.GONE);
        loadingView.setVisibility(View.VISIBLE);
        webView.setWebViewClient(new WebViewClient() {
            @Override
            public void onPageFinished(WebView view, String url) {
                loadingView.setVisibility(View.GONE);
                if (errorPresent)
                {
                    displayErrorView();
                }
                else
                {
                    showWebView();
                }
                super.onPageFinished(view, url);
                Logger.d(PrivacyPolicyFragment.class.getSimpleName()+": onPageFinished()");
            }

            @Override
            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                super.onReceivedError(view, request, error);
                errorPresent = true;
                Logger.d(PrivacyPolicyFragment.class.getSimpleName()+": onReceivedError() error: "+error.toString());
            }
        });
    }

    private void displayErrorView(){
        webView.setVisibility(View.GONE);
        errorView.setVisibility(View.VISIBLE);
    }

    private void showWebView(){
        webView.setVisibility(View.VISIBLE);
        errorView.setVisibility(View.GONE);
    }

    @Override
    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString(ConciergeConstants.STATE_URL, url);
        outState.putBoolean(ConciergeConstants.STATE_ERROR_PRESENT,errorPresent);
        webView.saveState(outState);
    }
}
