package com.flybits.concierge.fragments;


import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.flybits.android.kernel.ContentAnalytics;
import com.flybits.android.kernel.models.LocalizedValue;
import com.flybits.concierge.ConciergeFragment;
import com.flybits.concierge.FlybitsViewPopulator;
import com.flybits.concierge.R;
import com.flybits.concierge.Utils;
import com.flybits.concierge.models.BaseTemplate;
import com.flybits.concierge.models.Schedule;
import com.flybits.concierge.models.ScheduleSegment;
import com.flybits.concierge.models.Text;
import com.flybits.concierge.viewholders.FlybitsViewHolder;
import com.flybits.concierge.viewholders.ScheduleSegmentViewHolder;
import com.flybits.concierge.viewholders.ScheduleTitleViewHolder;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ScheduleFeedFragment extends Fragment
{
    private static final String ARG_SCHEDULE = "flybits_con_arg_schedule";
    private static final int DAYS_SHOWN = 7;
    private ConciergeFragment conciergeFragment;

    private enum ScheduleCellType
    {
        TITLE,
        SEGMENT
    }

    private RecyclerView recyclerView;
    private Schedule schedule;
    private Map<String, LinkedList<ScheduleSegment>> weekSegments;
    private List<BaseTemplate> data;
    private FlybitsViewPopulator flybitsViewPopulator;

    public ScheduleFeedFragment()
    {
        // Required empty public constructor
    }

    public static ScheduleFeedFragment newInstance(Schedule schedule)
    {
        ScheduleFeedFragment fragment = new ScheduleFeedFragment();
        Bundle args = new Bundle();
        args.putParcelable(ARG_SCHEDULE, schedule);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);

        flybitsViewPopulator = new FlybitsViewPopulator(new ContentAnalytics(getContext().getApplicationContext()));

        if (getArguments() != null)
        {
            schedule = getArguments().getParcelable(ARG_SCHEDULE);
            if (schedule != null)
            {
                weekSegments = schedule.generateSegmentList();
                data = new ArrayList<>();

                Calendar now = Calendar.getInstance();
                for (int i = 0; i < DAYS_SHOWN; i++)
                {
                    String weekDay = Utils.getWeekDayString(now.getTime());

                    LinkedList<ScheduleSegment> todaySegments = weekSegments.get(weekDay);

                    if (todaySegments != null) // only handle days that have an element
                    {
                        // add title
                        Text title = new Text();
                        String lang = Locale.getDefault().getLanguage();
                        LocalizedValue value = new LocalizedValue(lang, lang);
                        value.addValue(lang, Utils.getDateString(now.getTime()));
                        title.header = value;

                        data.add(title);

                        for (ScheduleSegment segment : todaySegments)
                        {
                            data.add(segment);
                        }
                    }

                    // increment day by 1
                    now.set(Calendar.DAY_OF_YEAR, now.get(Calendar.DAY_OF_YEAR) + 1);
                }
            }
        }
    }


    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState)
    {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.flybits_con_fragment_schedule_feed, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState)
    {
        super.onViewCreated(view, savedInstanceState);

        recyclerView = view.findViewById(R.id.flybits_con_fragment_schedule_feed_lytRecycler);
        recyclerView.setLayoutManager(new LinearLayoutManager(getContext()));
        recyclerView.setAdapter(new SegmentAdapter());

        conciergeFragment = Utils.getConciergeFragment(getActivity());
    }

    private class SegmentAdapter extends RecyclerView.Adapter<FlybitsViewHolder<? extends BaseTemplate>>
    {
        @NonNull
        @Override
        public FlybitsViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType)
        {
            ScheduleCellType type = ScheduleCellType.values()[viewType];

            switch (type)
            {
                case TITLE:
                    return new ScheduleTitleViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.flybits_con_item_template_schedule_title, parent, false));
                case SEGMENT:
                    return new ScheduleSegmentViewHolder(conciergeFragment, LayoutInflater.from(parent.getContext()).inflate(R.layout.flybits_con_item_template_schedule_segment, parent, false), flybitsViewPopulator);
            }

            return null;
        }

        @Override
        public void onBindViewHolder(@NonNull FlybitsViewHolder holder, int position)
        {
            holder.bindData(data.get(position), conciergeFragment);
            if (holder instanceof  ScheduleSegmentViewHolder)
            {
                ((ScheduleSegmentViewHolder) holder).setLast((position == (getItemCount() - 1)) || (data.get(position + 1) instanceof Text));
            }
        }

        @Override
        public int getItemCount()
        {
            return data.size();
        }

        @Override
        public int getItemViewType(int position)
        {
            return (data.get(position) instanceof ScheduleSegment ? ScheduleCellType.SEGMENT : ScheduleCellType.TITLE).ordinal();
        }
    }
}
