package com.flybits.concierge.activities

import android.os.Bundle
import android.view.MenuItem
import com.flybits.concierge.ConciergeFragment
import com.flybits.concierge.R

/**
 * Wrapper activity to hold the ConciergeFragment if the developer does not want to embed
 * the fragment in their views.
 */

class ConciergeActivity : ConciergeAbstractActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.flybits_con_activity_concierge)
        setTitle(R.string.flybits_con_concierge)

        val actionBar = supportActionBar
        if (actionBar != null) {
            actionBar.setHomeButtonEnabled(true)
            actionBar.setDisplayHomeAsUpEnabled(true)
        }

        val fragment = ConciergeFragment.newInstance(ConciergeFragment.MenuType.MENU_TYPE_APP_BAR)
        fragment.setCallback { finish() }
        openFragment(fragment)
    }

    override fun onOptionsItemSelected(item: MenuItem?): Boolean {
        return if (item?.itemId == android.R.id.home) {
            finish()
            true
        }
        else {
            super.onOptionsItemSelected(item)
        }
    }
}
