package com.flybits.concierge.activities

import android.os.Bundle
import android.support.v7.app.AppCompatActivity
import com.flybits.concierge.R
import com.flybits.concierge.fragments.EventDetailsFragment
import com.flybits.concierge.models.Event

class EventDetailsActivity: AppCompatActivity() {

    companion object {
        const val EXTRA_EVENT_DETAILS = "flybits_con_extra_event_details"
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.flybits_con_activity_single_content_holder)
        val event: Event? = intent.getParcelableExtra<Event>(EXTRA_EVENT_DETAILS)
        if (event != null){
            EventDetailsFragment.newInstance(event)
        }
    }
}