package com.flybits.concierge.activities

import android.os.Bundle
import android.support.v4.app.Fragment
import android.support.v7.app.AppCompatActivity
import android.view.MenuItem
import com.flybits.commons.library.logging.Logger
import com.flybits.concierge.R
import com.flybits.concierge.fragments.PrivacyPolicyFragment
import com.flybits.concierge.fragments.TermsAndServicesFragment

/**
 * This activity is responsible for displaying either the Terms of Service or Privacy Policy.
 */
class DocumentActivity: AppCompatActivity() {

    companion object {
        const val EXTRA_DOCUMENT_TYPE = "flybits_con_extra_document_type"
        const val DOCUMENT_TYPE_PRIVACY_POLICY = "flybits_con_document_type_privacy_policy"
        const val DOCUMENT_TYPE_TOS= "flybits_con_document_type_terms_of_service"
    }

    private fun openFragment(fragment: Fragment){
        supportFragmentManager
                .beginTransaction()
                .add(R.id.flybits_con_fragment_holder, fragment)
                .commit()
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.flybits_con_activity_single_content_holder)

        supportActionBar?.setDisplayHomeAsUpEnabled(true)
        val type: String = intent.extras.getString(EXTRA_DOCUMENT_TYPE, DOCUMENT_TYPE_PRIVACY_POLICY)
        when (type){
            DOCUMENT_TYPE_PRIVACY_POLICY -> {
                openFragment(PrivacyPolicyFragment.newInstance())
                supportActionBar?.title = resources.getString(R.string.flybits_con_settings_privacy_policy)
            }
            DOCUMENT_TYPE_TOS -> {
                openFragment(TermsAndServicesFragment.newInstance(true))
                supportActionBar?.title = resources.getString(R.string.flybits_con_settings_terms_of_service)
            }
            else -> {
                Logger.e("Invalid document type found")
                finish()
            }
        }
    }

    override fun onOptionsItemSelected(item: MenuItem?): Boolean {
        return if (item?.itemId == android.R.id.home) {
            onBackPressed()
            true
        } else {
            super.onOptionsItemSelected(item)
        }
    }

}