/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.fragments;

import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import com.flybits.concierge.ConciergeFragment;
import com.flybits.concierge.R;
import com.flybits.concierge.Utils;
import com.flybits.concierge.fragments.VideoFragment;
import com.flybits.concierge.models.ScheduleSegment;

public class ScheduleSegmentFragment
extends Fragment {
    private static final String ARG_SCHEDULE_SEGMENT = "flybits_con_arg_schedule_segment";
    private ScheduleSegment scheduleSegment;
    private ConciergeFragment conciergeFragment;

    public static ScheduleSegmentFragment newInstance(ScheduleSegment segment) {
        ScheduleSegmentFragment fragment = new ScheduleSegmentFragment();
        Bundle args = new Bundle();
        args.putParcelable(ARG_SCHEDULE_SEGMENT, (Parcelable)segment);
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.scheduleSegment = (ScheduleSegment)this.getArguments().getParcelable(ARG_SCHEDULE_SEGMENT);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.flybits_con_fragment_schedule_segment, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        TextView titleText = (TextView)view.findViewById(R.id.flybits_con_fragment_schedule_segment_txtTitle);
        TextView timeRangeText = (TextView)view.findViewById(R.id.flybits_con_fragment_schedule_segment_txtTimeRange);
        TextView descriptionText = (TextView)view.findViewById(R.id.flybits_con_fragment_schedule_segment_txtDescription);
        Button callToActionButton = (Button)view.findViewById(R.id.flybits_con_fragment_schedule_segment_btnCallToAction);
        this.conciergeFragment = Utils.getConciergeFragment(this.getActivity());
        titleText.setText((CharSequence)this.scheduleSegment.title.getValue());
        descriptionText.setText((CharSequence)this.scheduleSegment.description.getValue());
        timeRangeText.setText((CharSequence)Utils.getTimeRange(this.scheduleSegment.getStartDayTime(), this.scheduleSegment.getEndDayTime()));
        callToActionButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String url = ((ScheduleSegmentFragment)ScheduleSegmentFragment.this).scheduleSegment.url;
                VideoFragment fragment = VideoFragment.newInstance(url);
                ScheduleSegmentFragment.this.conciergeFragment.openFragment(fragment, true);
            }
        });
    }
}

