/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.widget.Snackbar;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.media.MediaBrowserCompat;
import android.support.v4.media.session.MediaControllerCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.afollestad.materialdialogs.MaterialDialog;
import com.flybits.android.kernel.ContentAnalytics;
import com.flybits.android.kernel.models.Content;
import com.flybits.android.kernel.utilities.ContentParameters;
import com.flybits.commons.library.api.results.callbacks.PagedResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import com.flybits.concierge.AuthenticationStatusListener;
import com.flybits.concierge.FlybitsConcierge;
import com.flybits.concierge.FlybitsNavigator;
import com.flybits.concierge.FlybitsViewPopulator;
import com.flybits.concierge.FlybitsViewProvider;
import com.flybits.concierge.FlybitsViewProviderGetter;
import com.flybits.concierge.InternalPreferences;
import com.flybits.concierge.OnboardingListener;
import com.flybits.concierge.OptOutListener;
import com.flybits.concierge.R;
import com.flybits.concierge.SurveyListener;
import com.flybits.concierge.exception.ConciergeException;
import com.flybits.concierge.fragments.FeedHolderFragment;
import com.flybits.concierge.fragments.OnboardingFragment;
import com.flybits.concierge.fragments.SurveyFragment;
import com.flybits.concierge.fragments.TermsAndServicesFragment;
import com.flybits.concierge.models.Audio;
import com.flybits.concierge.models.Onboarding;
import com.flybits.concierge.models.Survey;
import com.flybits.concierge.repository.ModelConverter;
import com.flybits.concierge.repository.content.ContentGetter;
import com.flybits.concierge.services.AudioService;
import com.flybits.concierge.viewproviders.AudiosViewProvider;
import com.pierfrancescosoffritti.androidyoutubeplayer.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ConciergeFragment
extends Fragment
implements AuthenticationStatusListener,
OptOutListener,
FlybitsNavigator,
FlybitsViewProviderGetter {
    public static final String INSTANCE_CURRENT_FRAGMENT = "instance_current_fragment";
    public static final int MESSAGE_TNC = 1;
    public static final int MESSAGE_ONBOARDING = 2;
    private LinearLayout lytLoader;
    private TextView txtLoaderText;
    private LinearLayout errorViewContainer;
    private View mainViewContainer;
    private View optInContainer;
    private Context currentContext;
    private Fragment currentFragment;
    private BroadcastReceiver optOutReceiver;
    private IConciergeFragmentCallbacks currentCallback;
    private MediaBrowserCompat mediaBrowserCompat;
    private MediaControllerCompat mediaControllerCompat;
    private MediaControllerCompat.Callback pendingCallback;
    private Audio lastAudio = null;
    private boolean initializing = false;
    private FlybitsConcierge flybitsConcierge;
    private MediaControllerCompat.Callback controllerCallback = new MediaControllerCompat.Callback(){

        public void onPlaybackStateChanged(PlaybackStateCompat state) {
            FragmentActivity activity = ConciergeFragment.this.getActivity();
            if (activity != null) {
                Intent intent = new Intent("flybits_con_broadcast_audio_state");
                intent.putExtra("flybits_con_intent_extra_audio_state", (Parcelable)state);
                activity.sendBroadcast(intent);
            }
        }
    };
    private MediaBrowserCompat.ConnectionCallback mediaBrowserCompatConnectionCallback = new MediaBrowserCompat.ConnectionCallback(){

        public void onConnected() {
            super.onConnected();
            Context context = ConciergeFragment.this.getContext();
            if (context != null) {
                try {
                    Bundle extras;
                    ConciergeFragment.this.mediaControllerCompat = new MediaControllerCompat(context, ConciergeFragment.this.mediaBrowserCompat.getSessionToken());
                    ConciergeFragment.this.mediaControllerCompat.registerCallback(ConciergeFragment.this.controllerCallback);
                    if (ConciergeFragment.this.pendingCallback != null) {
                        ConciergeFragment.this.mediaControllerCompat.registerCallback(ConciergeFragment.this.pendingCallback);
                        ConciergeFragment.this.pendingCallback = null;
                    }
                    if ((extras = ConciergeFragment.this.mediaControllerCompat.getPlaybackState().getExtras()) != null && ConciergeFragment.this.lastAudio == null) {
                        ConciergeFragment.this.lastAudio = new Audio();
                        ((ConciergeFragment)ConciergeFragment.this).lastAudio.sourceURL = extras.getString("arg_currentAudioURL");
                    } else if (ConciergeFragment.this.lastAudio != null) {
                        ConciergeFragment.this.playFromMediaId(ConciergeFragment.this.lastAudio);
                    }
                }
                catch (RemoteException e) {
                    Logger.exception(null, (Exception)((Object)e));
                }
            }
        }
    };

    public void childMessage(int code, Object data) {
        switch (code) {
            case 1: {
                boolean result = (Boolean)data;
                if (result) {
                    this.initializeState(false);
                    break;
                }
                if (this.currentCallback == null) break;
                this.currentCallback.onTNCDecline();
                break;
            }
            case 2: {
                this.initializeState(false);
            }
        }
    }

    public static ConciergeFragment newInstance() {
        ConciergeFragment fragment = new ConciergeFragment();
        return fragment;
    }

    public void setArguments(@Nullable Bundle args) {
        super.setArguments(args);
        this.initializeState(false);
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.currentFragment = this.getChildFragmentManager().getFragment(savedInstanceState, INSTANCE_CURRENT_FRAGMENT);
        }
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.currentFragment != null) {
            this.getChildFragmentManager().putFragment(outState, INSTANCE_CURRENT_FRAGMENT, this.currentFragment);
        }
        outState.putBoolean("flybits_con_error_present", this.errorViewContainer.getVisibility() == 0);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.flybits_con_fragment_concierge, container, false);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.lytLoader = (LinearLayout)view.findViewById(R.id.concierge_fragment_lytLoader);
        this.txtLoaderText = (TextView)view.findViewById(R.id.concierge_fragment_txtLoadingText);
        this.errorViewContainer = (LinearLayout)view.findViewById(R.id.concierge_fragment_error_holder);
        this.mainViewContainer = view.findViewById(this.contentLayout());
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("flybits_con_broadcast_opt_out");
        this.optOutReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                ConciergeFragment.this.initializeState(false);
            }
        };
        this.getActivity().registerReceiver(this.optOutReceiver, intentFilter);
        this.optInContainer = view.findViewById(R.id.concierge_fragment_opt_in_container);
        view.findViewById(R.id.flybits_con_fragment_btnOptIn).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                InternalPreferences.setDidOptOut(ConciergeFragment.this.currentContext, false);
                FlybitsConcierge.with(ConciergeFragment.this.currentContext).optInRetryAuthentication();
            }
        });
        view.findViewById(R.id.concierge_fragment_retry_button).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ConciergeFragment.this.initializeState(false);
            }
        });
        ContentAnalytics contentAnalytics = new ContentAnalytics(this.getContext());
        FlybitsViewPopulator flybitsViewPopulator = new FlybitsViewPopulator(contentAnalytics);
        this.flybitsConcierge = FlybitsConcierge.with(this.currentContext);
        this.flybitsConcierge.registerAuthenticationStateListener(this);
        this.flybitsConcierge.registerOptOutListener(this);
        this.flybitsConcierge.registerFlybitsViewProvider(new AudiosViewProvider(this, flybitsViewPopulator));
        this.initializeState(false);
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.flybitsConcierge != null) {
            this.flybitsConcierge.unregisterAuthenticationStateListener(this);
            this.flybitsConcierge.unregisterOptOutListener(this);
        }
        this.getActivity().unregisterReceiver(this.optOutReceiver);
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        this.currentContext = context;
    }

    public void onDetach() {
        super.onDetach();
        if (this.mediaBrowserCompat != null && this.mediaBrowserCompat.isConnected()) {
            this.mediaBrowserCompat.disconnect();
        }
        this.disconnectFromAudioService();
    }

    private void initializeState(boolean skipOnboarding) {
        if (this.initializing) {
            return;
        }
        this.initializing = true;
        this.errorViewContainer.setVisibility(8);
        this.optInContainer.setVisibility(8);
        this.mainViewContainer.setVisibility(4);
        if (this.flybitsConcierge.isAuthenticated() && !InternalPreferences.getDidOptOut(this.currentContext)) {
            this.mainViewContainer.setVisibility(0);
            this.flybitsConcierge.unregisterAuthenticationStateListener(this);
            if (FlybitsConcierge.with(this.currentContext).getConfiguration().getTNCUrl() != null && !InternalPreferences.isTNCAccepted(this.currentContext)) {
                this.hideLoader();
                this.currentFragment = TermsAndServicesFragment.newInstance(false);
                FragmentManager manager = this.getChildFragmentManager();
                manager.beginTransaction().replace(this.contentLayout(), this.currentFragment).commit();
            } else if (!skipOnboarding && !InternalPreferences.isOnBoardingDone(this.currentContext)) {
                this.hideLoader();
                this.findContentAndTakeover("ctn-flybits-concierge-onboarding");
                InternalPreferences.saveOnBoardingDone(this.currentContext, true);
            } else if (!InternalPreferences.isSurveyDone(this.currentContext)) {
                this.hideLoader();
                this.findContentAndTakeover("SurveyQuestions");
                InternalPreferences.saveSurveyDone(this.currentContext, true);
            } else {
                this.hideLoader();
                this.currentFragment = FeedHolderFragment.Companion.newInstance();
                FragmentManager manager = this.getChildFragmentManager();
                manager.beginTransaction().replace(this.contentLayout(), this.currentFragment, this.currentFragment.getClass().getSimpleName()).commit();
            }
        } else if (InternalPreferences.getDidOptOut(this.currentContext)) {
            this.flybitsConcierge.registerAuthenticationStateListener(this);
            this.optInContainer.setVisibility(0);
        } else {
            boolean retrySuccess = this.flybitsConcierge.retryAuthentication();
            if (retrySuccess) {
                this.showLoader("");
            }
            this.errorViewContainer.setVisibility(0);
        }
        this.initializing = false;
    }

    private void findContentAndTakeover(String contentTemplateType) {
        ContentParameters params = new ContentParameters.Builder().setTemplateType(contentTemplateType).build();
        Content.get((Context)this.currentContext, (ContentParameters)params, (PagedResultCallback)new PagedResultCallback<Content>(){

            public void onSuccess(ArrayList<Content> items) {
                if (items.size() != 0) {
                    ConciergeFragment.this.showContent(items.get(0));
                } else {
                    ConciergeFragment.this.initializeState(true);
                }
            }

            public void onException(FlybitsException exception) {
            }

            public void onLoadedAllItems() {
            }
        });
    }

    private void showContent(Content contentToShow) {
        ModelConverter modelConverter = new ModelConverter(new ContentGetter(this.getContext()), this);
        this.hideLoader();
        FragmentManager manager = this.getChildFragmentManager();
        switch (contentToShow.getType()) {
            case "ctn-flybits-concierge-onboarding": {
                Onboarding onboarding = (Onboarding)modelConverter.contentToBaseTemplate(contentToShow);
                if (onboarding == null) {
                    this.initializeState(true);
                    return;
                }
                OnboardingFragment onboardingFragment = OnboardingFragment.newInstance(onboarding);
                onboardingFragment.setOnboardingListener(new OnboardingListener(){

                    @Override
                    public void onSkip() {
                        ConciergeFragment.this.initializeState(false);
                    }

                    @Override
                    public void onFinished() {
                        ConciergeFragment.this.initializeState(false);
                    }
                });
                this.currentFragment = onboardingFragment;
                manager.beginTransaction().replace(this.contentLayout(), this.currentFragment, this.currentFragment.getClass().getSimpleName()).commit();
                break;
            }
            case "SurveyQuestions": {
                Survey survey = (Survey)modelConverter.contentToBaseTemplate(contentToShow);
                if (survey == null || survey.questions.getList().isEmpty()) {
                    new MaterialDialog.Builder((Context)this.getActivity()).title(R.string.flybits_con_error).content(R.string.flybits_con_dialog_survey_error).positiveText(17039370).show();
                    InternalPreferences.saveSurveyDone(this.getContext(), true);
                    this.initializeState(false);
                    return;
                }
                SurveyFragment surveyFragment = SurveyFragment.newInstance(survey);
                surveyFragment.setSurveyListener(new SurveyListener(){

                    @Override
                    public void onFinished() {
                        ConciergeFragment.this.initializeState(false);
                        InternalPreferences.saveSurveyDone(ConciergeFragment.this.currentContext, true);
                    }
                });
                this.currentFragment = surveyFragment;
                manager.beginTransaction().replace(this.contentLayout(), this.currentFragment, this.currentFragment.getClass().getSimpleName()).commit();
                break;
            }
            default: {
                this.initializeState(false);
            }
        }
    }

    private void connectToAudioService() {
        Context context = this.getContext();
        if (context == null) {
            return;
        }
        if (this.mediaBrowserCompat == null) {
            this.mediaBrowserCompat = new MediaBrowserCompat(context.getApplicationContext(), new ComponentName(context.getApplicationContext(), AudioService.class), this.mediaBrowserCompatConnectionCallback, null);
        }
        this.mediaBrowserCompat.connect();
    }

    private void disconnectFromAudioService() {
        if (this.mediaBrowserCompat != null && this.mediaBrowserCompat.isConnected()) {
            this.mediaControllerCompat.unregisterCallback(this.controllerCallback);
            this.mediaBrowserCompat.disconnect();
        }
    }

    public void startAudio(Audio audio) {
        this.lastAudio = audio;
        boolean isOnline = Utils.isOnline((Context)this.currentContext);
        View view = this.getView();
        if (isOnline && (this.mediaBrowserCompat == null || !this.mediaBrowserCompat.isConnected())) {
            this.connectToAudioService();
        } else if (isOnline) {
            this.playFromMediaId(audio);
        } else if (view != null) {
            Snackbar.make((View)view, (int)R.string.flybits_con_audio_error_message, (int)0).show();
        }
    }

    public void registerMediaControllerCallback(MediaControllerCompat.Callback mediaControllerCallback) {
        if (mediaControllerCallback != null && this.mediaBrowserCompat != null && this.mediaBrowserCompat.isConnected()) {
            this.pendingCallback = null;
            this.mediaControllerCompat.registerCallback(mediaControllerCallback);
        } else {
            this.pendingCallback = mediaControllerCallback;
        }
    }

    public void resumeAudio() {
        View view = this.getView();
        Context context = this.getContext();
        if (this.mediaBrowserCompat != null && this.mediaBrowserCompat.isConnected() && context != null && Utils.isOnline((Context)context)) {
            this.mediaControllerCompat.getTransportControls().play();
        } else if (view != null) {
            Snackbar.make((View)view, (int)R.string.flybits_con_audio_error_message, (int)0).show();
        }
    }

    public void pauseAudio() {
        if (this.mediaControllerCompat != null && this.mediaControllerCompat.getTransportControls() != null) {
            this.mediaControllerCompat.getTransportControls().pause();
        }
    }

    public void stopAudio() {
        this.lastAudio = null;
        if (this.mediaControllerCompat != null && this.mediaControllerCompat.getTransportControls() != null) {
            this.mediaControllerCompat.getTransportControls().stop();
        }
    }

    public int getAudioState() {
        if (this.mediaBrowserCompat == null || !this.mediaBrowserCompat.isConnected()) {
            if (Build.VERSION.SDK_INT >= 21) {
                return 0;
            }
            return 0;
        }
        return this.mediaControllerCompat.getPlaybackState().getState();
    }

    private void playFromMediaId(Audio audio) {
        Bundle args = new Bundle();
        if (audio.title != null) {
            args.putString("arg_title", audio.title.getValue());
        }
        if (audio.description != null) {
            args.putString("arg_desc", audio.description.getValue());
        }
        if (this.mediaBrowserCompat != null && this.mediaBrowserCompat.isConnected()) {
            this.mediaControllerCompat.getTransportControls().playFromMediaId(audio.sourceURL, args);
        }
    }

    public Audio getCurrentAudio() {
        return this.lastAudio;
    }

    @Override
    public void openFragment(@NotNull Fragment fragment, boolean addToBackStack) {
        FragmentActivity fragmentActivity = this.getActivity();
        if (fragmentActivity != null) {
            FragmentTransaction transaction = fragmentActivity.getSupportFragmentManager().beginTransaction();
            if (addToBackStack) {
                transaction.addToBackStack(null);
            }
            transaction.replace(this.contentLayout(), fragment).commit();
        }
    }

    private void showLoader(String title) {
        if (this.currentFragment != null) {
            this.getChildFragmentManager().beginTransaction().remove(this.currentFragment).commit();
        }
        this.txtLoaderText.setText((CharSequence)title);
        this.lytLoader.setVisibility(0);
    }

    private void hideLoader() {
        this.txtLoaderText.setText((CharSequence)"");
        this.lytLoader.setVisibility(8);
    }

    private int contentLayout() {
        return R.id.concierge_fragment_lytContent;
    }

    public void setCallback(IConciergeFragmentCallbacks callback) {
        this.currentCallback = callback;
    }

    @Override
    public void onAuthenticated() {
        this.initializeState(false);
    }

    @Override
    public void onAuthenticationStarted() {
    }

    @Override
    public void onAuthenticationError(ConciergeException e) {
        this.errorViewContainer.setVisibility(0);
        this.hideLoader();
    }

    @Override
    public void onUserOptedOut() {
        if (this.getActivity() != null) {
            this.initializeState(true);
        }
    }

    @Override
    public void openUrl(@NotNull String url) {
        try {
            FragmentActivity activity = this.getActivity();
            if (activity == null || url == null) {
                return;
            }
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)url));
            if (intent.resolveActivity(activity.getPackageManager()) != null) {
                this.startActivity(intent);
                activity.finish();
            }
        }
        catch (Exception e) {
            Logger.exception((String)"ConciergeFragment.openUrl()", (Exception)e);
        }
    }

    @Override
    public void openDialog(@NotNull String content, @NotNull String title) {
        new MaterialDialog.Builder((Context)this.getActivity()).title((CharSequence)title).content((CharSequence)content).positiveText(17039370).dismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialogInterface) {
                ConciergeFragment.this.getActivity().finish();
            }
        }).show();
    }

    @Override
    public Collection<FlybitsViewProvider> getFlybitsViewProviders() {
        Context context = this.getContext();
        if (context == null) {
            return new ArrayList<FlybitsViewProvider>();
        }
        return FlybitsConcierge.with(context).getFlybitsViewProviders();
    }

    @Override
    public FlybitsViewProvider getFlybitsViewProvider(String contentType) {
        Context context = this.getContext();
        if (context == null) {
            return null;
        }
        return FlybitsConcierge.with(context).getFlybitsViewProvider(contentType);
    }

    public static interface IConciergeFragmentCallbacks {
        public void onTNCDecline();
    }
}

