/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import com.flybits.commons.library.logging.Logger;
import com.flybits.concierge.exception.ConciergeException;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.xmlpull.v1.XmlPullParserException;

public class ConciergeConfiguration {
    public static final String KEY_TWITTER_CONSUMER = "key_twitter_consumer";
    public static final String KEY_TWITTER_SECRET = "key_twitter_secret";
    private String projectID;
    private String tncUrl = null;
    private String privacyPolicyUrl = null;
    private boolean isAnonymous = true;
    private HashMap<String, String> apiMap = new LinkedHashMap<String, String>();

    private ConciergeConfiguration() {
    }

    private ConciergeConfiguration(Builder builder) {
        this.projectID = builder.projectID;
        this.isAnonymous = builder.isAnonymous;
        this.tncUrl = builder.tncUrl;
        this.apiMap = builder.apiMap;
    }

    static ConciergeConfiguration loadConfiguration(Context context) {
        SharedPreferences preferences = context.getSharedPreferences("", 0);
        ConciergeConfiguration cfg = new ConciergeConfiguration();
        cfg.projectID = preferences.getString("projectID", null);
        cfg.isAnonymous = preferences.getBoolean("isAnonymous", true);
        cfg.tncUrl = preferences.getString(null, "tncUrl");
        cfg.privacyPolicyUrl = preferences.getString(null, "privacyPolicyUrl");
        return cfg;
    }

    static ConciergeConfiguration createFromXML(Context context, int cfgResource) {
        Resources res = context.getResources();
        XmlResourceParser xrp = res.getXml(cfgResource);
        boolean scanninConcierge = false;
        boolean doneScan = false;
        ConciergeConfiguration cfg = new ConciergeConfiguration();
        try {
            int eventType = xrp.getEventType();
            while (eventType != 1) {
                if (eventType == 0) {
                    System.out.println("Start document");
                } else if (eventType == 2) {
                    switch (xrp.getName()) {
                        case "concierge": {
                            scanninConcierge = true;
                            cfg.projectID = xrp.getAttributeValue(null, "projectID");
                            cfg.isAnonymous = xrp.getAttributeBooleanValue(null, "anonymous", false);
                            cfg.tncUrl = xrp.getAttributeValue(null, "tncUrl");
                            cfg.privacyPolicyUrl = xrp.getAttributeValue(null, "privacyPolicyUrl");
                            break;
                        }
                        case "api": {
                            if (!scanninConcierge) break;
                            String apiName = xrp.getAttributeValue(null, "name");
                            String apiKey = xrp.getAttributeValue(null, "value");
                            cfg.apiMap.put(apiName, apiKey);
                        }
                    }
                } else if (eventType == 3) {
                    String endTag;
                    switch (endTag = xrp.getName()) {
                        case "concierge": {
                            doneScan = true;
                        }
                    }
                } else if (eventType == 4) {
                    System.out.println("Text " + xrp.getText());
                }
                if (!doneScan) {
                    eventType = xrp.next();
                    continue;
                }
                break;
            }
        }
        catch (XmlPullParserException e) {
            throw new ConciergeException("Concierge: Cfg syntax error.");
        }
        catch (IOException e) {
            Logger.exception((String)ConciergeConfiguration.class.getSimpleName(), (Exception)e);
        }
        xrp.close();
        if (cfg.projectID == null) {
            throw new ConciergeException("Developer: The projectID attribute didn't exist.");
        }
        return cfg;
    }

    public String getProjectID() {
        return this.projectID;
    }

    public String getTNCUrl() {
        return this.tncUrl;
    }

    public String getPrivacyPolicyUrl() {
        return this.privacyPolicyUrl;
    }

    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    public String getApiKey(String key) {
        return this.apiMap.get(key);
    }

    class Builder {
        String projectID;
        boolean isAnonymous;
        String tncUrl = null;
        HashMap<String, String> apiMap = new HashMap();

        public Builder setProjectID(String id) {
            this.projectID = id;
            return this;
        }

        public Builder isAnonymous(boolean isAnon) {
            this.isAnonymous = isAnon;
            return this;
        }

        public Builder termsAndServicesRequired(String tncUrl) {
            this.tncUrl = tncUrl;
            return this;
        }

        public Builder addAPI(String apiName, String apiKey) {
            this.apiMap.put(apiName, apiKey);
            return this;
        }

        public ConciergeConfiguration build() {
            return new ConciergeConfiguration(this);
        }
    }
}

