package com.flybits.concierge.fragments;


import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;

import com.flybits.concierge.ConciergeFragment;
import com.flybits.concierge.R;
import com.flybits.concierge.Utils;
import com.flybits.concierge.models.ScheduleSegment;

public class ScheduleSegmentFragment extends Fragment
{
    private static final String ARG_SCHEDULE_SEGMENT = "flybits_con_arg_schedule_segment";

    private ScheduleSegment scheduleSegment;
    private ConciergeFragment conciergeFragment;

    public ScheduleSegmentFragment()
    {
        // Required empty public constructor
    }

    public static ScheduleSegmentFragment newInstance(ScheduleSegment segment)
    {
        ScheduleSegmentFragment fragment = new ScheduleSegmentFragment();
        Bundle args = new Bundle();
        args.putParcelable(ARG_SCHEDULE_SEGMENT, segment);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        if (getArguments() != null)
        {
            scheduleSegment = getArguments().getParcelable(ARG_SCHEDULE_SEGMENT);
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState)
    {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.flybits_con_fragment_schedule_segment, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState)
    {
        super.onViewCreated(view, savedInstanceState);

        TextView titleText = view.findViewById(R.id.flybits_con_fragment_schedule_segment_txtTitle);
        TextView timeRangeText = view.findViewById(R.id.flybits_con_fragment_schedule_segment_txtTimeRange);
        TextView descriptionText = view.findViewById(R.id.flybits_con_fragment_schedule_segment_txtDescription);
        Button callToActionButton = view.findViewById(R.id.flybits_con_fragment_schedule_segment_btnCallToAction);

        conciergeFragment = Utils.getConciergeFragment(getActivity());

        titleText.setText(scheduleSegment.title.getValue());
        descriptionText.setText(scheduleSegment.description.getValue());
        timeRangeText.setText(Utils.getTimeRange(scheduleSegment.getStartDayTime(), scheduleSegment.getEndDayTime()));
        callToActionButton.setOnClickListener(new View.OnClickListener()
        {
            @Override
            public void onClick(View v)
            {
                String url = scheduleSegment.url;
                VideoFragment fragment = VideoFragment.newInstance(url);
                conciergeFragment.openFragment(fragment, true);
            }
        });
    }
}
