package com.flybits.concierge.activities

import android.content.Intent
import android.os.Bundle
import android.view.Menu
import android.view.MenuItem
import com.flybits.concierge.ConciergeFragment
import com.flybits.concierge.R

/**
 * Wrapper activity to hold the ConciergeFragment if the developer does not want to embed
 * the fragment in their views.
 */

class ConciergeActivity : ConciergeAbstractActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.flybits_con_activity_concierge)
        setTitle(R.string.flybits_con_concierge)
        val actionBar = supportActionBar
        if (actionBar != null) {
            actionBar.setHomeButtonEnabled(true)
            actionBar.setDisplayHomeAsUpEnabled(true)
        }

        val fragment = supportFragmentManager.findFragmentById(R.id.activity_concierge_frgWrapper) as ConciergeFragment
        fragment.setCallback { finish() }
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        val id = item.itemId
        return when (id) {
            android.R.id.home -> {
                onBackPressed()
                true
            }
            R.id.settings -> {
                startSettingsActivity()
                true
            }
            R.id.notifications -> {
                startNotificationsActivity()
                true
            }
            else -> super.onOptionsItemSelected(item)
        }
    }

    override fun onCreateOptionsMenu(menu: Menu): Boolean {
        val inflater = menuInflater
        inflater.inflate(R.menu.menu, menu)
        return true
    }

    fun startSettingsActivity() {
        val startSettingsIntent = Intent(this, SettingsActivity::class.java)
        startActivityForResult(startSettingsIntent, SettingsActivity.REQUEST_CODE)
    }
}
