/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.services;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.NotificationManagerCompat;
import android.support.v4.media.MediaBrowserCompat;
import android.support.v4.media.MediaBrowserServiceCompat;
import android.support.v4.media.app.NotificationCompat;
import android.support.v4.media.session.MediaButtonReceiver;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import com.flybits.commons.library.logging.Logger;
import com.flybits.concierge.R;
import java.io.IOException;
import java.util.List;

public class AudioService
extends MediaBrowserServiceCompat
implements AudioManager.OnAudioFocusChangeListener {
    private static final String LOG_TAG = "ConciergeAudio";
    public static final String ARG_TITLE = "arg_title";
    public static final String ARG_DESC = "arg_desc";
    public static final String ARG_URL = "arg_currentAudioURL";
    private static String playingURL;
    private static int playingState;
    private MediaSessionCompat mediaSession;
    private PlaybackStateCompat.Builder stateBuilder;
    private MediaPlayer mediaPlayer;
    private String currentMusicTitle = null;
    private String currentMusicDescription = null;
    private String currentMusicArtURL = null;
    public String currentMusicURL = null;
    public static final String AUDIO_CHANNEL = "FLYBITS_CONCIERGE_AUDIO";
    private static final String PLAYING_ACTION = "com.flybits.concierge.action.playing";
    private static final String STOPPING_ACTION = "com.flybits.concierge.action.stopping";
    private static final String PAUSING_ACTION = "com.flybits.concierge.action.pausing";
    private MediaSessionCompat.Callback mediaSessionCallback = new MediaSessionCompat.Callback(){

        public void onPlay() {
            super.onPlay();
            if (!AudioService.this.successfullyRetrievedAudioFocus()) {
                return;
            }
            AudioService.this.startService(new Intent(AudioService.this.getApplicationContext(), AudioService.class));
            AudioService.this.mediaSession.setActive(true);
            AudioService.this.setMediaPlaybackState(3);
            NotificationCompat.Builder builder = new NotificationCompat.Builder(AudioService.this.getBaseContext(), AudioService.AUDIO_CHANNEL);
            builder.setContentTitle((CharSequence)(AudioService.this.currentMusicTitle != null ? AudioService.this.currentMusicTitle : "Untitled")).setContentText((CharSequence)(AudioService.this.currentMusicDescription != null ? AudioService.this.currentMusicDescription : "")).setSubText((CharSequence)AudioService.getApplicationName(AudioService.this.getApplicationContext())).setContentIntent(AudioService.this.mediaSession.getController().getSessionActivity()).setOngoing(true).setOnlyAlertOnce(true).setDeleteIntent(MediaButtonReceiver.buildMediaButtonPendingIntent((Context)AudioService.this.getBaseContext(), (long)1L)).setVisibility(1).addAction(new NotificationCompat.Action(R.drawable.ic_baseline_pause_24px, (CharSequence)"Pause", MediaButtonReceiver.buildMediaButtonPendingIntent((Context)AudioService.this.getBaseContext(), (long)512L))).addAction(new NotificationCompat.Action(R.drawable.ic_baseline_close_24px, (CharSequence)"Stop", MediaButtonReceiver.buildMediaButtonPendingIntent((Context)AudioService.this.getBaseContext(), (long)1L))).setStyle((NotificationCompat.Style)new NotificationCompat.MediaStyle().setShowActionsInCompactView(new int[]{0, 1}).setMediaSession(AudioService.this.mediaSession.getSessionToken())).setSmallIcon(R.drawable.ic_audio);
            AudioService.this.startForeground(1, builder.build());
            AudioService.this.mediaPlayer.start();
            Intent playIntent = new Intent(AudioService.PLAYING_ACTION);
            AudioService.this.getApplicationContext().sendBroadcast(playIntent);
            Logger.i((String)"Playing audio.");
        }

        public void onPause() {
            super.onPause();
            if (AudioService.this.mediaPlayer.isPlaying()) {
                AudioService.this.mediaPlayer.pause();
                AudioService.this.setMediaPlaybackState(2);
                NotificationCompat.Builder builder = new NotificationCompat.Builder(AudioService.this.getBaseContext(), AudioService.AUDIO_CHANNEL);
                builder.setContentTitle((CharSequence)(AudioService.this.currentMusicTitle != null ? AudioService.this.currentMusicTitle : "Untitled")).setContentText((CharSequence)(AudioService.this.currentMusicDescription != null ? AudioService.this.currentMusicDescription : "")).setSubText((CharSequence)AudioService.getApplicationName(AudioService.this.getApplicationContext())).setOnlyAlertOnce(true).setOngoing(false).setContentIntent(AudioService.this.mediaSession.getController().getSessionActivity()).setDeleteIntent(MediaButtonReceiver.buildMediaButtonPendingIntent((Context)AudioService.this.getBaseContext(), (long)1L)).setVisibility(1).addAction(new NotificationCompat.Action(R.drawable.ic_baseline_play_arrow_24px, (CharSequence)"Play", MediaButtonReceiver.buildMediaButtonPendingIntent((Context)AudioService.this.getBaseContext(), (long)512L))).addAction(new NotificationCompat.Action(R.drawable.ic_baseline_close_24px, (CharSequence)"Stop", MediaButtonReceiver.buildMediaButtonPendingIntent((Context)AudioService.this.getBaseContext(), (long)1L))).setStyle((NotificationCompat.Style)new NotificationCompat.MediaStyle().setShowActionsInCompactView(new int[]{0, 1}).setMediaSession(AudioService.this.mediaSession.getSessionToken())).setSmallIcon(R.drawable.ic_baseline_volume_up_24px);
                AudioService.this.startForeground(1, builder.build());
            }
            Intent pausingIntent = new Intent(AudioService.PAUSING_ACTION);
            AudioService.this.getApplicationContext().sendBroadcast(pausingIntent);
            Logger.i((String)"Pausing audio.");
        }

        public void onPlayFromMediaId(String mediaId, Bundle extras) {
            super.onPlayFromMediaId(mediaId, extras);
            playingURL = mediaId;
            try {
                AudioService.this.mediaPlayer.reset();
                AudioService.this.mediaPlayer.setDataSource(mediaId);
            }
            catch (IllegalStateException e) {
                AudioService.this.mediaPlayer.setWakeMode(AudioService.this.getApplicationContext(), 1);
                AudioService.this.mediaPlayer.setAudioStreamType(3);
                AudioService.this.mediaPlayer.setVolume(1.0f, 1.0f);
                try {
                    AudioService.this.mediaPlayer.setDataSource(mediaId);
                }
                catch (IOException e1) {
                    Logger.exception((String)AudioService.class.getSimpleName(), (Exception)e1);
                }
            }
            catch (IOException e) {
                Logger.exception((String)AudioService.class.getSimpleName(), (Exception)e);
            }
            AudioService.this.mediaPlayer.prepareAsync();
            AudioService.this.mediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                public void onPrepared(MediaPlayer mediaPlayer) {
                    AudioService.this.mediaSession.getController().getTransportControls().play();
                }
            });
            AudioService.this.currentMusicTitle = extras.getString(AudioService.ARG_TITLE, null);
            AudioService.this.currentMusicDescription = extras.getString(AudioService.ARG_DESC, null);
            AudioService.this.currentMusicURL = mediaId;
            Logger.i((String)"Loading and playing audio.");
        }

        public void onStop() {
            super.onStop();
            AudioService.this.setMediaPlaybackState(1);
            AudioService.this.mediaPlayer.stop();
            AudioService.this.mediaPlayer.reset();
            AudioService.this.stopForeground(true);
            AudioService.this.stopSelf();
            Intent stopIntent = new Intent(AudioService.STOPPING_ACTION);
            AudioService.this.getApplicationContext().sendBroadcast(stopIntent);
            Logger.i((String)"Stopping audio.");
            playingURL = null;
        }
    };

    public static String getPlayingURL() {
        return playingURL;
    }

    public static int getPlayingState() {
        return playingState;
    }

    public void onTaskRemoved(Intent rootIntent) {
        super.onTaskRemoved(rootIntent);
        this.stopSelf();
    }

    public void onCreate() {
        super.onCreate();
        this.mediaPlayer = new MediaPlayer();
        this.mediaPlayer.setWakeMode(this.getApplicationContext(), 1);
        this.mediaPlayer.setAudioStreamType(3);
        this.mediaPlayer.setVolume(1.0f, 1.0f);
        ComponentName mediaButtonReceiver = new ComponentName(this.getApplicationContext(), MediaButtonReceiver.class);
        this.mediaSession = new MediaSessionCompat(this.getApplicationContext(), LOG_TAG, mediaButtonReceiver, null);
        this.mediaSession.setCallback(this.mediaSessionCallback);
        this.mediaSession.setFlags(3);
        this.stateBuilder = new PlaybackStateCompat.Builder().setActions(517L);
        this.mediaSession.setPlaybackState(this.stateBuilder.build());
        Intent mediaButtonIntent = new Intent("android.intent.action.MEDIA_BUTTON");
        mediaButtonIntent.setClass((Context)this, MediaButtonReceiver.class);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)mediaButtonIntent, (int)0);
        this.mediaSession.setMediaButtonReceiver(pendingIntent);
        this.setSessionToken(this.mediaSession.getSessionToken());
        NotificationCompat.Builder builder = new NotificationCompat.Builder(this.getBaseContext(), AUDIO_CHANNEL);
        builder.setContentTitle((CharSequence)(this.currentMusicTitle != null ? this.currentMusicTitle : "Untitled")).setContentText((CharSequence)(this.currentMusicDescription != null ? this.currentMusicDescription : "")).setSubText((CharSequence)AudioService.getApplicationName(this.getApplicationContext())).setContentIntent(this.mediaSession.getController().getSessionActivity()).setOngoing(true).setDeleteIntent(MediaButtonReceiver.buildMediaButtonPendingIntent((Context)this.getBaseContext(), (long)1L)).setVisibility(1).addAction(new NotificationCompat.Action(R.drawable.ic_baseline_pause_24px, (CharSequence)"Pause", MediaButtonReceiver.buildMediaButtonPendingIntent((Context)this.getBaseContext(), (long)512L))).setStyle((NotificationCompat.Style)new NotificationCompat.MediaStyle().setShowActionsInCompactView(new int[]{0}).setMediaSession(this.mediaSession.getSessionToken())).setSmallIcon(R.drawable.ic_audio);
        if (Build.VERSION.SDK_INT >= 26) {
            this.startForeground(1, builder.build());
        }
        Logger.i((String)"Created");
    }

    public void onDestroy() {
        super.onDestroy();
        this.mediaPlayer.stop();
        this.mediaPlayer.reset();
        this.mediaSession.release();
        NotificationManagerCompat.from((Context)this).cancel(1);
        Logger.i((String)"Destroyed");
    }

    private void setMediaPlaybackState(int state) {
        playingState = state;
        PlaybackStateCompat.Builder playbackstateBuilder = new PlaybackStateCompat.Builder();
        if (state == 3) {
            playbackstateBuilder.setActions(515L);
        } else if (state == 2) {
            playbackstateBuilder.setActions(517L);
        } else if (state == 1) {
            playbackstateBuilder.setActions(1L);
        }
        playbackstateBuilder.setState(state, -1L, 0.0f);
        Bundle extraBundle = new Bundle();
        extraBundle.putString(ARG_URL, this.currentMusicURL);
        playbackstateBuilder.setExtras(extraBundle);
        this.mediaSession.setPlaybackState(playbackstateBuilder.build());
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        MediaButtonReceiver.handleIntent((MediaSessionCompat)this.mediaSession, (Intent)intent);
        return 2;
    }

    @Nullable
    public MediaBrowserServiceCompat.BrowserRoot onGetRoot(@NonNull String clientPackageName, int clientUid, @Nullable Bundle rootHints) {
        return new MediaBrowserServiceCompat.BrowserRoot("Audio_Concierge_Root", null);
    }

    public void onLoadChildren(@NonNull String parentId, @NonNull MediaBrowserServiceCompat.Result<List<MediaBrowserCompat.MediaItem>> result) {
        result.sendResult(null);
    }

    private boolean successfullyRetrievedAudioFocus() {
        AudioManager audioManager = (AudioManager)this.getSystemService("audio");
        int result = audioManager.requestAudioFocus((AudioManager.OnAudioFocusChangeListener)this, 3, 1);
        return result == 1;
    }

    private static String getApplicationName(Context context) {
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        int stringId = applicationInfo.labelRes;
        return stringId == 0 ? applicationInfo.nonLocalizedLabel.toString() : context.getString(stringId);
    }

    public void onAudioFocusChange(int focusChange) {
        switch (focusChange) {
            case -1: {
                if (!this.mediaPlayer.isPlaying()) break;
                this.mediaSession.getController().getTransportControls().pause();
                break;
            }
            case -2: {
                this.mediaSession.getController().getTransportControls().pause();
                break;
            }
            case -3: {
                if (this.mediaPlayer == null) break;
                this.mediaPlayer.setVolume(0.3f, 0.3f);
                break;
            }
            case 1: {
                if (this.mediaPlayer == null) break;
                if (!this.mediaPlayer.isPlaying()) {
                    this.mediaSession.getController().getTransportControls().play();
                }
                this.mediaPlayer.setVolume(1.0f, 1.0f);
            }
        }
    }
}

