package com.flybits.concierge.viewholders;

import android.view.View;
import android.widget.TextView;

import com.flybits.concierge.FlybitsNavigator;
import com.flybits.concierge.R;
import com.flybits.concierge.models.Text;

public class TextViewHolder extends FlybitsViewHolder<Text> {

    private View thisView;
    private TextView txtHeading;
    private TextView txtBody;

    public TextViewHolder(View itemView)
    {
        super(itemView);
        this.thisView = itemView;
        this.txtHeading = itemView.findViewById(R.id.flybits_con_item_template_text_txtTitle);
        this.txtBody = itemView.findViewById(R.id.flybits_con_item_template_text_txtBody);
    }

    @Override
    public void bindData(Text data, FlybitsNavigator flybitsNavigator) {
        txtHeading.setText(data.header.getValue());
        txtBody.setText(data.description.getValue());
    }

}
