package com.flybits.concierge.models;

import android.os.Parcel;

import com.flybits.android.kernel.models.LocalizedValue;
import com.flybits.commons.library.logging.Logger;
import com.flybits.concierge.Utils;

import java.text.ParseException;
import java.util.Date;

public class Event extends BaseTemplate
{
    public LocalizedValue title;
    public String coverPhotoURL;
    public LocalizedValue venueDescription;
    public String url;
    public String address;
    public String phoneNumber;
    public String startDate;
    public String endDate;
    public LocalizedValue description;

    public Event()
    {
    }

    public Date getStartDate()
    {
        try
        {
            return Utils.toCalendar(startDate).getTime();
        }
        catch (ParseException e)
        {
            Logger.exception(Event.class.getSimpleName(), e);
        }

        return null;
    }

    public Date getEndDate()
    {
        try
        {
            return Utils.toCalendar(endDate).getTime();
        }
        catch (ParseException e)
        {
            Logger.exception(Event.class.getSimpleName(), e);
        }

        return null;
    }

    protected Event(Parcel in)
    {
        super(in);
        title = in.readParcelable(LocalizedValue.class.getClassLoader());
        coverPhotoURL = in.readString();
        venueDescription = in.readParcelable(LocalizedValue.class.getClassLoader());
        url = in.readString();
        address = in.readString();
        phoneNumber = in.readString();
        startDate = in.readString();
        endDate = in.readString();
        description = in.readParcelable(LocalizedValue.class.getClassLoader());
    }

    public static final Creator<Event> CREATOR = new Creator<Event>()
    {
        @Override
        public Event createFromParcel(Parcel in)
        {
            return new Event(in);
        }

        @Override
        public Event[] newArray(int size)
        {
            return new Event[size];
        }
    };

    @Override
    public int describeContents()
    {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags)
    {
        super.writeToParcel(dest,flags);
        dest.writeParcelable(title, flags);
        dest.writeString(coverPhotoURL);
        dest.writeParcelable(venueDescription, flags);
        dest.writeString(url);
        dest.writeString(address);
        dest.writeString(phoneNumber);
        dest.writeString(startDate);
        dest.writeString(endDate);
        dest.writeParcelable(description, flags);
    }
}
