package com.flybits.concierge.activities

import android.content.Intent
import android.net.Uri
import android.os.Bundle
import android.support.v4.app.Fragment
import android.support.v7.app.AppCompatActivity
import android.view.MenuItem
import com.afollestad.materialdialogs.MaterialDialog
import com.flybits.android.push.models.Push
import com.flybits.commons.library.logging.Logger
import com.flybits.concierge.*
import com.flybits.concierge.fragments.NotificationsFragment
import com.flybits.concierge.models.BaseTemplate

class NotificationsActivity: AppCompatActivity(), FlybitsNavigator, FlybitsViewProviderGetter {

    override fun openFragment(fragment: Fragment, addToBackStack: Boolean) {
        val transaction = supportFragmentManager.beginTransaction()
        if (addToBackStack){
            transaction.addToBackStack(null)
        }
        transaction.replace(R.id.flybits_con_activity_notifications_fragment_holder, fragment)
                .commit()
    }

    override fun openUrl(url: String) {
        val intent = Intent(Intent.ACTION_VIEW, Uri.parse(url))
        //verify that you're able to open url, if URL is malformed then exception is thrown
        if (intent.resolveActivity(packageManager) != null){
            startActivity(intent)
        } else {
            Logger.e("NotificationsActivity: Unable to show url $url, make sure it has http:// prefixed.")
        }
    }

    override fun openDialog(content: String, title: String) {
        MaterialDialog.Builder(this)
                .title(title)
                .content(content)
                .positiveText(android.R.string.ok)
                .show()
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        return if (item.itemId == android.R.id.home) {
            onBackPressed()
            true
        } else {
            super.onOptionsItemSelected(item)
        }
    }

    override fun onBackPressed() {
        super.onBackPressed()
        intent.removeExtra(ConciergeConstants.PUSH_EXTRA)
    }

    override fun onSaveInstanceState(outState: Bundle?) {
        super.onSaveInstanceState(outState)
        outState?.putInt("state_counter", 1)
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.flybits_con_activity_notifications)

        val notificationsFragment = if (intent.hasExtra(ConciergeConstants.PUSH_EXTRA)){
            val push = intent.getParcelableExtra<Push>(ConciergeConstants.PUSH_EXTRA)
            NotificationsFragment.newInstance(push)
        } else {
            NotificationsFragment.newInstance()
        }
        openFragment(notificationsFragment, savedInstanceState?.getInt("state_counter",0) == 1)

        val actionBar = supportActionBar
        actionBar?.setDisplayHomeAsUpEnabled(true)
        actionBar?.title = getString(R.string.flybits_con_notifications)
    }

    override fun getFlybitsViewProviders(): Collection<FlybitsViewProvider<BaseTemplate>>? {
        applicationContext?.let {
            return FlybitsConcierge.with(it).flybitsViewProviders
        } ?: return emptyList()
    }

    override fun getFlybitsViewProvider(contentType: String): FlybitsViewProvider<BaseTemplate>? {
        applicationContext?.let { nonNullContext ->
            return FlybitsConcierge.with(nonNullContext).flybitsViewProviders
                    .find { it.getContentType() == contentType } as FlybitsViewProvider<BaseTemplate>?
        } ?: return null
    }

}