package com.flybits.concierge.activities

import android.content.Intent
import android.os.Bundle
import android.support.v7.app.AppCompatActivity
import com.flybits.android.push.models.Push

import com.flybits.commons.library.logging.Logger
import com.flybits.concierge.ConciergeConstants

abstract class ConciergeAbstractActivity : AppCompatActivity() {

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        Logger.d("onActivityResult() requestCode: $requestCode, resultCode: $resultCode")
        if (resultCode == SettingsActivity.RESULT_OPT_OUT) {
            // Activities can handle their own onOptOutClose situation
        } else
            super.onActivityResult(requestCode, resultCode, data)
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        if (intent.hasExtra(ConciergeConstants.PUSH_EXTRA) && savedInstanceState == null){
            startNotificationsActivity(intent)
            intent.removeExtra(ConciergeConstants.PUSH_EXTRA)
        }
    }

    /**
     * Start notifications activity. Pass [Push] if one is available in the intent.
     *
     * @param intent Intent potentially containing [Push] extra to be displayed inside the
     * [NotificationsActivity]. Null by default.
     */
    fun startNotificationsActivity(intent: Intent? = null) {
        val push = intent?.getParcelableExtra<Push>(ConciergeConstants.PUSH_EXTRA)
        val activityIntent = Intent(this, NotificationsActivity::class.java)
        if (push != null){
            activityIntent.putExtra(ConciergeConstants.PUSH_EXTRA, push)
        }
        startActivity(activityIntent)
    }
}
