/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.fragments;

import android.arch.lifecycle.ViewModelProviders;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Switch;
import com.afollestad.materialdialogs.DialogAction;
import com.afollestad.materialdialogs.MaterialDialog;
import com.flybits.concierge.OptOutCallback;
import com.flybits.concierge.R;
import com.flybits.concierge.activities.SettingsActivity;
import com.flybits.concierge.exception.ConciergeException;
import com.flybits.concierge.viewmodels.SettingsViewModel;

public class SettingsFragment
extends Fragment {
    private Switch optSwitch;
    private View termsOfService;
    private View privacyPolicy;
    private MaterialDialog optOutDialog;
    private SettingsViewModel viewModel;

    public static SettingsFragment newInstance() {
        return new SettingsFragment();
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.flybits_con_fragment_settings, container, false);
        return view;
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.viewModel = (SettingsViewModel)ViewModelProviders.of((Fragment)this).get(SettingsViewModel.class);
        this.optSwitch = (Switch)view.findViewById(R.id.flybits_con_settings_opt_switch);
        this.termsOfService = view.findViewById(R.id.flybits_con_settings_terms_of_service_text);
        this.privacyPolicy = view.findViewById(R.id.flybits_con_settings_privacy_policy_text);
        FragmentActivity activity = this.getActivity();
        if (activity != null && this.optOutDialog == null) {
            this.optOutDialog = new MaterialDialog.Builder((Context)activity).title(R.string.flybits_con_opt_out).positiveText(R.string.flybits_con_yes).negativeText(R.string.flybits_con_no).content(R.string.flybits_con_opt_out_warning).onPositive(new MaterialDialog.SingleButtonCallback(){

                public void onClick(@NonNull MaterialDialog dialog, @NonNull DialogAction which) {
                    FragmentActivity activity = SettingsFragment.this.getActivity();
                    if (activity instanceof SettingsActivity) {
                        SettingsFragment.this.viewModel.optOutFlybits(new OptOutCallback(){

                            @Override
                            public void onSuccess() {
                                FragmentActivity settingsActivity = SettingsFragment.this.getActivity();
                                if (settingsActivity instanceof SettingsActivity) {
                                    ((SettingsActivity)settingsActivity).optOutOfFlybits();
                                }
                            }

                            @Override
                            public void onError(ConciergeException e) {
                                new Handler(Looper.myLooper()).post(new Runnable(){

                                    @Override
                                    public void run() {
                                        FragmentActivity hostActivity = SettingsFragment.this.getActivity();
                                        if (hostActivity != null) {
                                            new MaterialDialog.Builder((Context)hostActivity).title(R.string.flybits_con_error).content(R.string.flybits_con_opt_out_network_error).positiveText(17039370).show();
                                        }
                                    }
                                });
                            }
                        });
                    }
                }
            }).dismissListener(new DialogInterface.OnDismissListener(){

                public void onDismiss(DialogInterface dialogInterface) {
                    if (SettingsFragment.this.optSwitch != null) {
                        SettingsFragment.this.optSwitch.setChecked(false);
                    }
                }
            }).build();
        }
        this.optSwitch.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (SettingsFragment.this.optSwitch.isChecked()) {
                    SettingsFragment.this.displayOptOutDialog();
                }
            }
        });
        this.termsOfService.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                FragmentActivity activity = SettingsFragment.this.getActivity();
                if (activity instanceof SettingsActivity) {
                    ((SettingsActivity)activity).switchToTermsOfService();
                }
            }
        });
        this.privacyPolicy.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                FragmentActivity activity = SettingsFragment.this.getActivity();
                if (activity instanceof SettingsActivity) {
                    ((SettingsActivity)activity).switchToPrivacyPolicy();
                }
            }
        });
    }

    private void displayOptOutDialog() {
        Context context = this.getContext();
        if (context != null) {
            this.optOutDialog.show();
        }
    }

    public void onStop() {
        if (this.optOutDialog != null) {
            this.optOutDialog.dismiss();
        }
        super.onStop();
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.optOutDialog != null) {
            outState.putAll(this.optOutDialog.onSaveInstanceState());
        }
    }

    public void onViewStateRestored(@Nullable Bundle savedInstanceState) {
        super.onViewStateRestored(savedInstanceState);
        if (this.optOutDialog != null && savedInstanceState != null) {
            this.optOutDialog.onRestoreInstanceState(savedInstanceState);
        }
    }
}

