package com.flybits.concierge.repository

import android.content.Context
import com.flybits.android.kernel.models.Content
import com.flybits.commons.library.exceptions.FlybitsException
import com.flybits.commons.library.logging.Logger
import com.flybits.concierge.FlybitsViewProviderGetter
import com.flybits.concierge.models.BaseTemplate
import com.flybits.concierge.models.Events
import java.util.*

class ModelConverter(private val context: Context, private val flybitsViewProviderGetter: FlybitsViewProviderGetter) {

    fun contentToBaseTemplate(content: Content): BaseTemplate? {
        val flybitsViewProvider
                = flybitsViewProviderGetter.getFlybitsViewProvider(content.type) ?: return null

        val typeClass = flybitsViewProvider.getClassType()

        return contentToBaseTemplate(typeClass, content)
    }

    fun contentToBaseTemplate(typeClass: Class<BaseTemplate>, content: Content): BaseTemplate? {
        try {
            val contentObject: BaseTemplate? = content.getData(context, typeClass)
            if (contentObject != null) {
                contentObject.content = content
                return contentObject
            }
        } catch (e: FlybitsException) {
            Logger.d(String.format(Locale.getDefault(), "Developer: Invalid Template Found: %s", content.type))
            Logger.exception(BaseTemplate::class.java.simpleName, e)
        }


        return null
    }

    /**
     * Get list of supported content types.
     *
     * @return List of content types that are registered in the {@link FlybitsViewProviderGetter}
     */
    fun getSupportedTypes(): List<String> = flybitsViewProviderGetter.flybitsViewProviders?.map { it.getContentType() } ?: emptyList()

}