/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.fragments;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.flybits.android.kernel.ContentAnalytics;
import com.flybits.concierge.ConciergeFragment;
import com.flybits.concierge.FlybitsNavigator;
import com.flybits.concierge.FlybitsViewPopulator;
import com.flybits.concierge.R;
import com.flybits.concierge.Utils;
import com.flybits.concierge.models.Video;
import com.flybits.concierge.viewholders.VideoViewHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class VideoPlaylistFragment
extends Fragment {
    private static final String ARG_VIDEOS = "flybits_con_playlist_args";
    private List<Video> videos;
    private ConciergeFragment conciergeFragment;
    private RecyclerView recyclerView;
    private TextView titleView;
    private FlybitsViewPopulator flybitsViewPopulator;

    public static VideoPlaylistFragment newInstance(ArrayList<Video> videos) {
        VideoPlaylistFragment fragment = new VideoPlaylistFragment();
        Bundle args = new Bundle();
        args.putParcelableArrayList(ARG_VIDEOS, videos);
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.videos = this.getArguments().getParcelableArrayList(ARG_VIDEOS);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.flybits_con_fragment_video_playlist, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.flybitsViewPopulator = new FlybitsViewPopulator(new ContentAnalytics(this.getContext().getApplicationContext()));
        this.titleView = (TextView)view.findViewById(R.id.flybits_con_fragment_video_playlist_txtTitle);
        this.recyclerView = (RecyclerView)view.findViewById(R.id.flybits_con_fragment_video_playlist_lytRecycler);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.recyclerView.setAdapter((RecyclerView.Adapter)new PlaylistAdapter());
        this.conciergeFragment = Utils.getConciergeFragment(this.getActivity());
        this.titleView.setText((CharSequence)String.format(Locale.getDefault(), "%d Videos", this.videos.size()));
    }

    private class PlaylistAdapter
    extends RecyclerView.Adapter<VideoViewHolder> {
        private PlaylistAdapter() {
        }

        @NonNull
        public VideoViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            return new VideoViewHolder(VideoPlaylistFragment.this.flybitsViewPopulator, VideoPlaylistFragment.this.conciergeFragment, LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.flybits_con_item_template_video, parent, false));
        }

        public void onBindViewHolder(@NonNull VideoViewHolder holder, int position) {
            holder.bindData((Video)VideoPlaylistFragment.this.videos.get(position), (FlybitsNavigator)VideoPlaylistFragment.this.conciergeFragment);
        }

        public int getItemCount() {
            return VideoPlaylistFragment.this.videos != null ? VideoPlaylistFragment.this.videos.size() : 0;
        }
    }
}

