package com.flybits.concierge.viewproviders

import android.view.LayoutInflater
import android.view.ViewGroup
import com.flybits.concierge.*
import com.flybits.concierge.fragments.VideoPlaylistFragment
import com.flybits.concierge.models.Videos
import com.flybits.concierge.viewholders.VideosViewHolder

class VideosViewProvider(private val flybitsViewPopulator: FlybitsViewPopulator): FlybitsViewProvider<Videos> {

    override fun getClassType() = Videos::class.java

    override fun getContentType() = ConciergeConstants.VIDEO_CONTENT_TYPE

    override fun onCreateViewHolder(parent: ViewGroup): VideosViewHolder {
        return VideosViewHolder(LayoutInflater.from(parent.context)
                .inflate(R.layout.flybits_con_item_template_videos, parent, false), flybitsViewPopulator)
    }

    override fun onPushOpened(model: Videos, flybitsNavigator: FlybitsNavigator) {
        flybitsNavigator.openFragment(VideoPlaylistFragment.newInstance(model.videos.list))
    }
}