package com.flybits.concierge.viewproviders

import android.view.LayoutInflater
import android.view.ViewGroup
import com.flybits.concierge.ConciergeConstants
import com.flybits.concierge.FlybitsNavigator
import com.flybits.concierge.FlybitsViewProvider
import com.flybits.concierge.R
import com.flybits.concierge.models.Text
import com.flybits.concierge.viewholders.FlybitsViewHolder
import com.flybits.concierge.viewholders.TextViewHolder

class TextViewProvider: FlybitsViewProvider<Text> {

    override fun getClassType() = Text::class.java

    override fun getContentType() = ConciergeConstants.TEXT_CONTENT_TYPE

    override fun onCreateViewHolder(parent: ViewGroup): FlybitsViewHolder<Text> {
        return TextViewHolder(LayoutInflater.from(parent.context).inflate(R.layout.flybits_con_item_text, parent, false))
    }

    override fun onPushOpened(model: Text, flybitsNavigator: FlybitsNavigator) {
        flybitsNavigator.openDialog(model.description.value, model.header.value)
    }
}