package com.flybits.concierge.viewproviders

import android.view.LayoutInflater
import android.view.ViewGroup
import com.flybits.concierge.*
import com.flybits.concierge.ConciergeConstants.IMAGE_CONTENT_TYPE
import com.flybits.concierge.fragments.ImageViewerPagerFragment
import com.flybits.concierge.models.Images
import com.flybits.concierge.viewholders.ImageViewHolder

class ImageViewProvider(private val flybitsViewPopulator: FlybitsViewPopulator
                        , private val conciergeFragment: ConciergeFragment): FlybitsViewProvider<Images> {

    override fun onCreateViewHolder(parent: ViewGroup): ImageViewHolder {
        return ImageViewHolder(conciergeFragment
                , LayoutInflater.from(parent.context)
                        .inflate(R.layout.flybits_con_item_image, parent, false), flybitsViewPopulator)
    }

    override fun getClassType() = Images::class.java

    override fun getContentType() = IMAGE_CONTENT_TYPE

    override fun onPushOpened(model: Images, flybitsNavigator: FlybitsNavigator) {
        flybitsNavigator.openFragment(ImageViewerPagerFragment.newInstance(model.images, 0))
    }
}