package com.flybits.concierge.activities;

import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.view.MenuItem;

import com.flybits.concierge.ConciergeConstants;
import com.flybits.concierge.R;
import com.flybits.concierge.fragments.PrivacyPolicyFragment;
import com.flybits.concierge.fragments.SettingsFragment;
import com.flybits.concierge.fragments.TermsAndServicesFragment;

public class SettingsActivity extends AppCompatActivity {

    public static final int RESULT_OPT_OUT = 8;
    public static final int REQUEST_CODE = 1;

    private SettingsFragment settingsFragment;
    private TermsAndServicesFragment termsAndServicesFragment;
    private PrivacyPolicyFragment privacyPolicyFragment;

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == android.R.id.home)
        {
            onBackPressed();
            return true;
        }else{
            return super.onOptionsItemSelected(item);
        }
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.flybits_con_activity_settings);

        settingsFragment = SettingsFragment.newInstance();
        termsAndServicesFragment = TermsAndServicesFragment.newInstance(true);
        privacyPolicyFragment = PrivacyPolicyFragment.newInstance();

        ActionBar actionBar = getSupportActionBar();
        if (actionBar != null){
            actionBar.setDisplayHomeAsUpEnabled(true);
        }

        if (savedInstanceState == null){
            switchToSettings();
        }
    }

    public void switchToPrivacyPolicy(){
        getSupportFragmentManager().beginTransaction()
                .replace(R.id.flybits_con_activity_settings_fragment_holder, privacyPolicyFragment)
                .addToBackStack("flybits_con_settings_to_privacy_policy")
                .commit();
    }

    public void switchToTermsOfService(){
        getSupportFragmentManager().beginTransaction()
                .replace(R.id.flybits_con_activity_settings_fragment_holder, termsAndServicesFragment)
                .addToBackStack("flybits_con_settings_to_terms_of_service")
                .commit();
    }

    public void switchToSettings(){
        getSupportFragmentManager().beginTransaction()
                .replace(R.id.flybits_con_activity_settings_fragment_holder, settingsFragment)
                .commit();
    }

    public void optOutOfFlybits(){
        setResult(RESULT_OPT_OUT);
        Intent intent = new Intent();
        intent.setAction(ConciergeConstants.BROADCAST_OPT_OUT);
        sendBroadcast(intent);
        finish();
    }
}
