/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.repository;

import android.content.Context;
import com.flybits.android.kernel.models.Content;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import com.flybits.concierge.FlybitsViewProvider;
import com.flybits.concierge.FlybitsViewProviderGetter;
import com.flybits.concierge.models.BaseTemplate;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/flybits/concierge/repository/ModelConverter;", "", "context", "Landroid/content/Context;", "flybitsViewProviderGetter", "Lcom/flybits/concierge/FlybitsViewProviderGetter;", "(Landroid/content/Context;Lcom/flybits/concierge/FlybitsViewProviderGetter;)V", "contentToBaseTemplate", "Lcom/flybits/concierge/models/BaseTemplate;", "content", "Lcom/flybits/android/kernel/models/Content;", "typeClass", "Ljava/lang/Class;", "concierge_release"})
public final class ModelConverter {
    private final Context context;
    private final FlybitsViewProviderGetter flybitsViewProviderGetter;

    @Nullable
    public final BaseTemplate contentToBaseTemplate(@NotNull Content content) {
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        FlybitsViewProvider flybitsViewProvider = this.flybitsViewProviderGetter.getFlybitsViewProvider(content.getType());
        if (flybitsViewProvider == null) {
            return null;
        }
        FlybitsViewProvider flybitsViewProvider2 = flybitsViewProvider;
        Class<BaseTemplate> typeClass = flybitsViewProvider2.getClassType();
        return this.contentToBaseTemplate(typeClass, content);
    }

    @Nullable
    public final BaseTemplate contentToBaseTemplate(@NotNull Class<BaseTemplate> typeClass, @NotNull Content content) {
        Intrinsics.checkParameterIsNotNull(typeClass, (String)"typeClass");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        try {
            BaseTemplate contentObject = (BaseTemplate)content.getData(this.context, typeClass);
            if (contentObject != null) {
                contentObject.setContent(content);
                return contentObject;
            }
        }
        catch (FlybitsException e) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.getDefault();
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.getDefault()");
            Locale locale2 = locale;
            String string2 = "Developer: Invalid Template Found: %s";
            Object[] objectArray = new Object[]{content.getType()};
            String string3 = String.format(locale2, string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
            Logger.d((String)string3);
            Logger.exception((String)BaseTemplate.class.getSimpleName(), (Exception)((Exception)((Object)e)));
        }
        return null;
    }

    public ModelConverter(@NotNull Context context, @NotNull FlybitsViewProviderGetter flybitsViewProviderGetter) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)flybitsViewProviderGetter, (String)"flybitsViewProviderGetter");
        this.context = context;
        this.flybitsViewProviderGetter = flybitsViewProviderGetter;
    }
}

