package com.flybits.concierge.viewholders;

import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.flybits.concierge.ConciergeFragment;
import com.flybits.concierge.FlybitsViewPopulator;
import com.flybits.concierge.FlybitsNavigator;
import com.flybits.concierge.R;
import com.flybits.concierge.models.Video;

public class VideoViewHolder extends FlybitsViewHolder<Video>
{
    private final TextView titleTextView;
    private final TextView durationTextView;
    private final ImageView placeholderImageView;
    private View thisView;
    private ConciergeFragment conciergeFragment;
    private FlybitsViewPopulator flybitsViewPopulator;

    public VideoViewHolder(FlybitsViewPopulator flybitsViewPopulator, ConciergeFragment conFrag, View view)
    {
        super(view);
        this.thisView = view;
        this.flybitsViewPopulator = flybitsViewPopulator;
        conciergeFragment = conFrag;
        titleTextView = view.findViewById(R.id.flybits_con_item_template_video_txtTitle);
        durationTextView = view.findViewById(R.id.flybits_con_item_template_video_txtDuration);
        placeholderImageView = view.findViewById(R.id.flybits_con_item_template_video_placeHolder);
    }

    @Override
    public void bindData(final Video data, FlybitsNavigator flybitsNavigator)
    {
        flybitsViewPopulator.populateVideoViews(data, data.getContent().getId(), conciergeFragment
                , titleTextView, durationTextView, placeholderImageView, thisView);
    }
}
