package com.flybits.concierge.fragments

import android.arch.lifecycle.Observer
import android.arch.lifecycle.ViewModelProviders
import android.os.Bundle
import android.support.design.widget.TabLayout
import android.support.v4.app.Fragment
import android.support.v4.app.FragmentManager
import android.support.v4.app.FragmentPagerAdapter
import android.support.v4.view.ViewPager
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import com.flybits.commons.library.logging.Logger
import com.flybits.concierge.R
import com.flybits.concierge.models.Category
import com.flybits.concierge.viewmodels.FeedHolderViewModel
import com.flybits.concierge.viewmodels.FeedHolderViewModelFactory

class CategoryFragmentPagerAdapter(fragmentManager: FragmentManager, var categoryList: List<Category>): FragmentPagerAdapter(fragmentManager) {

    init {
        Logger.d("${CategoryFragmentPagerAdapter::class.java.simpleName}: Creating, categoryList: $categoryList")
    }

    override fun getPageTitle(position: Int): CharSequence? {
        return categoryList[position].name
    }

    override fun getItem(position: Int): Fragment {
        return CategoryFragment.newInstance(categoryList[position].name)
    }

    override fun getCount() = categoryList.size

}

class FeedHolderFragment: Fragment() {

    companion object {
        fun newInstance(): FeedHolderFragment{
            return FeedHolderFragment()
        }
    }

    private var feedHolderViewModel: FeedHolderViewModel? = null

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        return inflater.inflate(R.layout.flybits_con_fragment_feed_holder, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        Logger.d("FeedHolderFragment: view created!")
        val viewPager: ViewPager = view.findViewById(R.id.category_view_pager)
        val tabLayout = view.findViewById<TabLayout>(R.id.category_tab_layout)
        viewPager.offscreenPageLimit = 3

        feedHolderViewModel = ViewModelProviders.of(this, FeedHolderViewModelFactory(context!!)).get(FeedHolderViewModel::class.java)
        feedHolderViewModel?.syncCategories()
        feedHolderViewModel?.getCategories()?.observe(this, Observer { categoryList ->
            Logger.d("FeedHolderFragment: Got categories: $categoryList")
            //add the default tab to the front
            categoryList?.add(0, Category(null, getString(R.string.flybits_con_default_tab_name)))
            childFragmentManager.let {
                if (viewPager.adapter == null || (viewPager.adapter as CategoryFragmentPagerAdapter).categoryList != categoryList){
                    val pagerAdapter = CategoryFragmentPagerAdapter(it, categoryList ?: emptyList())
                    viewPager.adapter = pagerAdapter
                    tabLayout.setupWithViewPager(viewPager)
                    Logger.d("FeedHolderFragment: view pager current item ${viewPager.currentItem}")
                }
            }
        })
    }
    
}