package com.flybits.concierge.viewholders;

import android.content.Context;
import android.view.View;
import android.widget.TextView;

import com.flybits.concierge.FlybitsNavigator;
import com.flybits.concierge.R;
import com.flybits.concierge.models.BaseTemplate;
import android.support.v4.content.ContextCompat;

public class UnknownViewHolder extends FlybitsViewHolder<BaseTemplate>
{
    TextView textView;

    public UnknownViewHolder(View itemView)
    {
        super(itemView);
        textView = (TextView) itemView;
    }

    @Override
    public void bindData(BaseTemplate data, FlybitsNavigator flybitsNavigator)
    {
        Context context = textView.getContext();
        textView.setTextColor(ContextCompat.getColor(context, R.color.flybits_con_primary));
        textView.setText(data == null ? context.getString(R.string.flybits_con_empty_view): data.toString());
    }
}
