package com.flybits.concierge.repository

import android.arch.persistence.room.Database
import android.arch.persistence.room.Room
import android.arch.persistence.room.RoomDatabase
import android.content.Context
import com.flybits.concierge.models.Category

@Database(entities = [Category::class], version = 1)
abstract class CategoryDatabase: RoomDatabase() {

    abstract fun categoryDao(): CategoryDao

    companion object {
        var INSTANCE: CategoryDatabase? = null

        fun getInstance(context: Context, debug: Boolean = false): CategoryDatabase? {
            if (INSTANCE == null){
                synchronized(CategoryDatabase::class){
                    val builder = Room.databaseBuilder(context, CategoryDatabase::class.java, "flybits-categories-db")
                    if (debug){
                        builder.allowMainThreadQueries()
                    }
                    INSTANCE = builder.build()
                }
            }

            return INSTANCE
        }

        fun destroyInstance() {
            INSTANCE = null
        }
    }
}