package com.flybits.concierge.models;

import android.os.Parcel;
import android.os.Parcelable;

import com.flybits.android.kernel.models.Content;

public abstract class BaseTemplate implements Parcelable
{
    private Content content;

    public BaseTemplate() {

    }

    protected BaseTemplate(Parcel p){
        this.content = p.readParcelable(Content.class.getClassLoader());
    }

    @Override
    public void writeToParcel(Parcel dest, int flags)
    {
        dest.writeParcelable(content, flags);
    }

    @Override
    public final String toString()
    {
        return getClass().getSimpleName();
    }

    public Content getContent()
    {
        return content;
    }

    public void setContent(Content content) {
        if (content == null) throw new IllegalArgumentException();
        this.content = content;
    }
}
