/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.models;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.UnderlineSpan;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.request.RequestOptions;
import com.flybits.android.kernel.models.LocalizedValue;
import com.flybits.commons.library.logging.Logger;
import com.flybits.concierge.FlybitsNavigator;
import com.flybits.concierge.Utils;
import com.flybits.concierge.fragments.EventDetailsFragment;
import com.flybits.concierge.models.BaseTemplate;
import java.text.ParseException;
import java.util.Date;

public class Event
extends BaseTemplate {
    public LocalizedValue title;
    public String coverPhotoURL;
    public LocalizedValue venueDescription;
    public String url;
    public String address;
    public String phoneNumber;
    public String startDate;
    public String endDate;
    public LocalizedValue description;
    public static final Parcelable.Creator<Event> CREATOR = new Parcelable.Creator<Event>(){

        public Event createFromParcel(Parcel in) {
            return new Event(in);
        }

        public Event[] newArray(int size) {
            return new Event[size];
        }
    };

    public Event() {
    }

    public Date getStartDate() {
        try {
            return Utils.toCalendar(this.startDate).getTime();
        }
        catch (ParseException e) {
            Logger.exception((String)Event.class.getSimpleName(), (Exception)e);
            return null;
        }
    }

    public Date getEndDate() {
        try {
            return Utils.toCalendar(this.endDate).getTime();
        }
        catch (ParseException e) {
            Logger.exception((String)Event.class.getSimpleName(), (Exception)e);
            return null;
        }
    }

    protected Event(Parcel in) {
        super(in);
        this.title = (LocalizedValue)in.readParcelable(LocalizedValue.class.getClassLoader());
        this.coverPhotoURL = in.readString();
        this.venueDescription = (LocalizedValue)in.readParcelable(LocalizedValue.class.getClassLoader());
        this.url = in.readString();
        this.address = in.readString();
        this.phoneNumber = in.readString();
        this.startDate = in.readString();
        this.endDate = in.readString();
        this.description = (LocalizedValue)in.readParcelable(LocalizedValue.class.getClassLoader());
    }

    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeParcelable((Parcelable)this.title, flags);
        dest.writeString(this.coverPhotoURL);
        dest.writeParcelable((Parcelable)this.venueDescription, flags);
        dest.writeString(this.url);
        dest.writeString(this.address);
        dest.writeString(this.phoneNumber);
        dest.writeString(this.startDate);
        dest.writeString(this.endDate);
        dest.writeParcelable((Parcelable)this.description, flags);
    }

    public void populateViews(FlybitsNavigator flybitsNavigator, TextView titleView, TextView locationView, TextView dateView, ImageView imgHeader, View expandView) {
        this.populateViews(flybitsNavigator, titleView, locationView, dateView, imgHeader, expandView, null, null, null);
    }

    public void populateViews(FlybitsNavigator flybitsNavigator, TextView titleView, TextView locationView, TextView dateView, ImageView imgHeader, View expandView, TextView addressView, TextView ctaView, TextView phoneView) {
        this.populateViews(flybitsNavigator, titleView, locationView, dateView, imgHeader, expandView, addressView, ctaView, phoneView, null);
    }

    public void populateViews(final FlybitsNavigator flybitsNavigator, TextView titleView, TextView locationView, TextView dateView, ImageView imgHeader, View expandView, TextView addressView, TextView ctaView, TextView phoneView, TextView descriptionView) {
        SpannableString content;
        RequestOptions options = new RequestOptions().centerCrop().format(DecodeFormat.PREFER_RGB_565);
        Glide.with((Context)imgHeader.getContext()).load(this.coverPhotoURL).apply(options).into(imgHeader);
        titleView.setText((CharSequence)(!TextUtils.isEmpty((CharSequence)this.title.getValue()) ? this.title.getValue() : ""));
        locationView.setText((CharSequence)(!TextUtils.isEmpty((CharSequence)this.venueDescription.getValue()) ? this.venueDescription.getValue() : ""));
        dateView.setText((CharSequence)Utils.getDateRange(this.getStartDate(), this.getEndDate()));
        if (expandView != null && flybitsNavigator != null) {
            expandView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    EventDetailsFragment fragment = EventDetailsFragment.newInstance(Event.this);
                    flybitsNavigator.openFragment(fragment);
                }
            });
        }
        if (addressView != null) {
            if (descriptionView != null) {
                content = new SpannableString((CharSequence)this.address);
                content.setSpan((Object)new UnderlineSpan(), 0, content.length(), 0);
                addressView.setText((CharSequence)content);
            } else {
                addressView.setText((CharSequence)this.address);
            }
        }
        if (ctaView != null) {
            ctaView.setVisibility(!TextUtils.isEmpty((CharSequence)this.url) ? 0 : 4);
            ctaView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    String url = Event.this.url;
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setData(Uri.parse((String)url));
                    v.getContext().startActivity(intent);
                }
            });
        }
        if (phoneView != null) {
            if (!TextUtils.isEmpty((CharSequence)this.phoneNumber)) {
                if (descriptionView != null) {
                    content = new SpannableString((CharSequence)this.phoneNumber);
                    content.setSpan((Object)new UnderlineSpan(), 0, content.length(), 0);
                    phoneView.setText((CharSequence)content);
                } else {
                    phoneView.setText((CharSequence)this.phoneNumber);
                }
            } else {
                phoneView.setText(17039374);
            }
        }
        if (descriptionView != null) {
            descriptionView.setText((CharSequence)this.description.getValue());
        }
    }
}

