/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.models;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import com.flybits.android.kernel.models.Content;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import com.flybits.concierge.FlybitsViewProvider;
import com.flybits.concierge.FlybitsViewProviderGetter;
import com.flybits.concierge.models.Events;
import java.util.Locale;

public abstract class BaseTemplate
implements Parcelable {
    private Content content;
    private BaseTemplate parent;

    public BaseTemplate() {
    }

    protected BaseTemplate(Parcel p) {
        this.content = (Content)p.readParcelable(Content.class.getClassLoader());
    }

    public static BaseTemplate fromContent(FlybitsViewProviderGetter flybitsViewProviderGetter, Content content, Context context) {
        FlybitsViewProvider flybitsViewProvider = flybitsViewProviderGetter.getFlybitsViewProvider(content.getType());
        if (flybitsViewProvider == null) {
            return null;
        }
        Class typeClass = flybitsViewProvider.getClassType();
        return BaseTemplate.fromContent(typeClass, content, context);
    }

    public static BaseTemplate fromContent(Class typeClass, Content content, Context context) {
        if (typeClass == Events.class) {
            Logger.d((String)("content as json: " + content.getDataAsJson()));
        }
        try {
            BaseTemplate contentObject = (BaseTemplate)content.getData(context, typeClass);
            if (contentObject != null) {
                contentObject.setContent(content);
                return contentObject;
            }
        }
        catch (FlybitsException e) {
            Logger.d((String)String.format(Locale.getDefault(), "Developer: Invalid Template Found: %s", content.getType()));
            Logger.exception((String)BaseTemplate.class.getSimpleName(), (Exception)((Object)e));
        }
        return null;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.content, flags);
    }

    public final String toString() {
        return this.getClass().getSimpleName();
    }

    public Content getContent() {
        return this.content;
    }

    public void setContent(Content content) {
        if (content == null) {
            throw new IllegalArgumentException();
        }
        this.content = content;
    }
}

