package com.flybits.concierge.viewproviders

import android.view.LayoutInflater
import android.view.ViewGroup
import com.flybits.concierge.ConciergeConstants.ARTICLE_CONTENT_TYPE
import com.flybits.concierge.FlybitsNavigator
import com.flybits.concierge.FlybitsViewProvider
import com.flybits.concierge.R
import com.flybits.concierge.models.Articles
import com.flybits.concierge.viewholders.ArticlesViewHolder

class ArticlesViewProvider: FlybitsViewProvider<Articles> {

    override fun getClassType() = Articles::class.java

    override fun getContentType() = ARTICLE_CONTENT_TYPE

    override fun onCreateViewHolder(container: ViewGroup): ArticlesViewHolder {
        val itemView = LayoutInflater.from(container.context).inflate(R.layout.flybits_con_item_articles, container, false)

        return ArticlesViewHolder(itemView)
    }

    override fun onPushOpened(model: Articles, flybitsNavigator: FlybitsNavigator) {
        flybitsNavigator.openUrl(model.articles.list[0].url)
    }
}