package com.flybits.concierge.models;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.widget.TextView;

import com.flybits.android.kernel.models.PagedArray;
import com.flybits.concierge.R;

import java.util.Locale;

public class Onboarding extends BaseTemplate
{
    public Onboarding()
    {
    }

    public PagedArray<OnboardingPage> onboardingPages;

    protected Onboarding(Parcel in)
    {
        super(in);
        onboardingPages = in.readParcelable(PagedArray.class.getClassLoader());
    }

    public static final Creator<Onboarding> CREATOR = new Creator<Onboarding>()
    {
        @Override
        public Onboarding createFromParcel(Parcel in)
        {
            return new Onboarding(in);
        }

        @Override
        public Onboarding[] newArray(int size)
        {
            return new Onboarding[size];
        }
    };

    @Override
    public int describeContents()
    {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags)
    {
        super.writeToParcel(dest,flags);
        dest.writeParcelable(onboardingPages, flags);
    }

    public void populateViews(TextView titleTextView)
    {
        String onBoardingTitle = null;

        for (OnboardingPage page : onboardingPages.getList())
        {
            if (!TextUtils.isEmpty(page.title.getValue()))
            {
                onBoardingTitle = page.title.getValue();
                break;
            }
        }

        String displayedTitle = String.format(Locale.getDefault(), titleTextView.getContext().getString(R.string.flybits_con_item_template_on_boarding_title_format), onBoardingTitle);

        titleTextView.setText(displayedTitle);
    }

}
