package com.flybits.concierge.fragments;


import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.flybits.concierge.ConciergeFragment;
import com.flybits.concierge.R;
import com.flybits.concierge.Utils;
import com.flybits.concierge.models.Video;
import com.flybits.concierge.viewholders.FlybitsViewHolder;
import com.flybits.concierge.viewholders.VideoViewHolder;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class VideoPlaylistFragment extends Fragment
{
    private static final String ARG_VIDEOS = "flybits_con_playlist_args";

    private List<Video> videos;
    private ConciergeFragment conciergeFragment;
    private RecyclerView recyclerView;
    private TextView titleView;

    public VideoPlaylistFragment()
    {
        // Required empty public constructor
    }

    public static VideoPlaylistFragment newInstance(ArrayList<Video> videos)
    {
        VideoPlaylistFragment fragment = new VideoPlaylistFragment();
        Bundle args = new Bundle();
        args.putParcelableArrayList(ARG_VIDEOS, videos);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        if (getArguments() != null)
        {
            videos = getArguments().getParcelableArrayList(ARG_VIDEOS);
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState)
    {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.flybits_con_fragment_video_playlist, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState)
    {
        super.onViewCreated(view, savedInstanceState);

        titleView = view.findViewById(R.id.flybits_con_fragment_video_playlist_txtTitle);

        recyclerView = view.findViewById(R.id.flybits_con_fragment_video_playlist_lytRecycler);
        recyclerView.setLayoutManager(new LinearLayoutManager(getContext()));
        recyclerView.setAdapter(new PlaylistAdapter());

        conciergeFragment = Utils.getConciergeFragment(getActivity());

        titleView.setText(String.format(Locale.getDefault(), "%d Videos", videos.size()));
    }

    private class PlaylistAdapter extends RecyclerView.Adapter<VideoViewHolder>
    {

        @NonNull
        @Override
        public VideoViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType)
        {
            return new VideoViewHolder(conciergeFragment, LayoutInflater.from(parent.getContext()).inflate(R.layout.flybits_con_item_template_video, parent, false));
        }

        @Override
        public void onBindViewHolder(@NonNull VideoViewHolder holder, int position)
        {
            holder.bindData(videos.get(position), conciergeFragment);
        }

        @Override
        public int getItemCount()
        {
            return videos != null ? videos.size() : 0;
        }
    }
}