package com.flybits.concierge.adapters;

import android.support.annotation.NonNull;
import android.support.v4.view.PagerAdapter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import com.flybits.concierge.R;
import com.flybits.concierge.models.Article;

import java.util.ArrayList;
import java.util.List;

public class ArticleAdapter extends PagerAdapter
{
    private List<Article> data;

    public ArticleAdapter()
    {
        data = new ArrayList<>();
    }

    public void setData(List<Article> data)
    {
        this.data = data;
        notifyDataSetChanged();
    }

    @NonNull
    @Override
    public Object instantiateItem(@NonNull ViewGroup container, int position)
    {
        // inflate our layout resource
        View itemView = LayoutInflater.from(container.getContext()).inflate(R.layout.flybits_con_item_article, container, false);

        container.addView(itemView);

        // get data
        Article article = data.get(position);

        // get fields
        TextView title = itemView.findViewById(R.id.flybits_con_article_txtTitle);
        TextView description = itemView.findViewById(R.id.flybits_con_article_txtDescription);
        TextView source = itemView.findViewById(R.id.flybits_con_article_txtSource);
        ImageView imageView = itemView.findViewById(R.id.flybits_con_article_imgHeader);

        article.populateViews(imageView, title, source, description, itemView);

        return itemView;
    }

    @Override
    public int getCount()
    {
        return data.size();
    }

    @Override
    public boolean isViewFromObject(@NonNull View view, @NonNull Object object)
    {
        return view == object;
    }

    @Override
    public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object)
    {
        container.removeView((View) object);
    }
}
