package com.flybits.concierge.activities;

import android.arch.lifecycle.Lifecycle;
import android.content.pm.ActivityInfo;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.view.View;

import com.flybits.concierge.R;
import com.pierfrancescosoffritti.androidyoutubeplayer.player.YouTubePlayer;
import com.pierfrancescosoffritti.androidyoutubeplayer.player.YouTubePlayerView;
import com.pierfrancescosoffritti.androidyoutubeplayer.player.listeners.AbstractYouTubePlayerListener;
import com.pierfrancescosoffritti.androidyoutubeplayer.player.listeners.YouTubePlayerFullScreenListener;
import com.pierfrancescosoffritti.androidyoutubeplayer.player.listeners.YouTubePlayerInitListener;
import com.pierfrancescosoffritti.androidyoutubeplayer.player.playerUtils.FullScreenHelper;

public class YouTubePlayerActivity extends AppCompatActivity
{

    public static final String ARG_ID_KEY = "flybits_con_arg_youtubeid";
    private YouTubePlayerView youTubePlayerView;
    private FullScreenHelper fullScreenHelper = new FullScreenHelper();
    private String youtubeVideoId;

    @Override
    protected void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.flybits_con_activity_you_tube_player);

        youTubePlayerView = findViewById(R.id.flybits_con_activity_you_tube_player_viewPlayer);
        youtubeVideoId = getIntent().getExtras().getString(ARG_ID_KEY);

        getLifecycle().addObserver(youTubePlayerView);

        youTubePlayerView.initialize(new YouTubePlayerInitListener()
        {
            @Override
            public void onInitSuccess(@NonNull final YouTubePlayer youTubePlayer)
            {
                youTubePlayer.addListener(new AbstractYouTubePlayerListener()
                {
                    @Override
                    public void onReady()
                    {
                        loadVideo(youTubePlayer, youtubeVideoId);
                    }
                });

                addFullScreenListenerToPlayer(youTubePlayer);
            }
        }, true);
    }

    private void loadVideo(YouTubePlayer youTubePlayer, String videoId)
    {
        if (getLifecycle().getCurrentState() == Lifecycle.State.RESUMED)
        {
            youTubePlayer.loadVideo(videoId, 0);
        }
        else
        {
            youTubePlayer.cueVideo(videoId, 0);
        }
    }

    private void addFullScreenListenerToPlayer(final YouTubePlayer youTubePlayer)
    {
        youTubePlayerView.addFullScreenListener(new YouTubePlayerFullScreenListener()
        {
            @Override
            public void onYouTubePlayerEnterFullScreen()
            {
                setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);
                fullScreenHelper.enterFullScreen(youTubePlayerView);

                addCustomActionToPlayer(youTubePlayer);
            }

            @Override
            public void onYouTubePlayerExitFullScreen()
            {
                setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
                fullScreenHelper.exitFullScreen(youTubePlayerView);

                removeCustomActionFromPlayer();
            }
        });
    }

    private void addCustomActionToPlayer(final YouTubePlayer youTubePlayer)
    {
        Drawable customActionIcon = ContextCompat.getDrawable(this, R.drawable.ic_pause_36dp);

        youTubePlayerView.getPlayerUIController()
                .setCustomAction1(customActionIcon, new View.OnClickListener()
                {
                    @Override
                    public void onClick(View v)
                    {
                        if (youTubePlayer != null)
                        {
                            youTubePlayer.pause();
                        }
                    }
                });
    }

    private void removeCustomActionFromPlayer()
    {
        youTubePlayerView.getPlayerUIController().showCustomAction1(false);
    }
}
