package com.flybits.concierge

import android.support.v4.app.Fragment

interface FlybitsNavigator {

    /**
     * Replaces the {@link FeedFragment} which hosts the recycler view, with the provided fragment.
     *
     * @param fragment The fragment that will be navigated to.
     */
    fun openFragment(fragment: Fragment)

    /**
     * Opens the provided url in the user selected browser.
     *
     * @url url that will be navigated to in the browser.
     *
     */
    fun openUrl(url: String)

    /**
     * Opens a dialog within the {@link FeedFragment} with the provided title, and content.
     *
     * @param content The content text that will appear in the body of the dialog.
     * @param title The title that will appear in the header of the dialog.
     *
     */
    fun openDialog(content: String, title: String)
}