/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.fragments;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.telephony.PhoneNumberUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.flybits.commons.library.logging.Logger;
import com.flybits.concierge.R;
import com.flybits.concierge.models.Event;
import java.util.Locale;

public class EventDetailsFragment
extends Fragment {
    private static final String ARG_CONTENT = "flybits_con_param_event";
    private static final int REQUEST_PHONE_CALL = 13;
    private Event event;

    public static EventDetailsFragment newInstance(Event event) {
        EventDetailsFragment fragment = new EventDetailsFragment();
        Bundle args = new Bundle();
        args.putParcelable(ARG_CONTENT, (Parcelable)event);
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.event = (Event)this.getArguments().getParcelable(ARG_CONTENT);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.flybits_con_fragment_event_details, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        ImageView headerImage = (ImageView)view.findViewById(R.id.flybits_con_fragment_event_details_imgHeader);
        TextView titleView = (TextView)view.findViewById(R.id.flybits_con_fragment_event_details_txtTitle);
        TextView locationView = (TextView)view.findViewById(R.id.flybits_con_fragment_event_details_txtLocation);
        TextView dateView = (TextView)view.findViewById(R.id.flybits_con_fragment_event_details_txtDate);
        TextView callToActionView = (TextView)view.findViewById(R.id.flybits_con_fragment_event_details_txtCallToAction);
        TextView addressView = (TextView)view.findViewById(R.id.flybits_con_fragment_event_details_txtAddress);
        TextView phoneView = (TextView)view.findViewById(R.id.flybits_con_fragment_event_details_txtPhone);
        TextView descriptionView = (TextView)view.findViewById(R.id.flybits_con_fragment_event_details_txtDescription);
        this.event.populateViews(null, titleView, locationView, dateView, headerImage, null, addressView, callToActionView, phoneView, descriptionView);
        phoneView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!PhoneNumberUtils.isGlobalPhoneNumber((String)((EventDetailsFragment)EventDetailsFragment.this).event.phoneNumber)) {
                    return;
                }
                if (ContextCompat.checkSelfPermission((Context)EventDetailsFragment.this.getActivity(), (String)"android.permission.CALL_PHONE") != 0) {
                    EventDetailsFragment.this.requestPermissions(new String[]{"android.permission.CALL_PHONE"}, 13);
                } else {
                    EventDetailsFragment.this.makePhoneCall();
                }
            }
        });
        addressView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                try {
                    Uri gmmIntentUri = Uri.parse((String)String.format(Locale.getDefault(), "geo:0,0?q=%s", ((EventDetailsFragment)EventDetailsFragment.this).event.address));
                    Intent mapIntent = new Intent("android.intent.action.VIEW", gmmIntentUri);
                    mapIntent.setPackage("com.google.android.apps.maps");
                    EventDetailsFragment.this.getActivity().startActivity(mapIntent);
                }
                catch (Exception e) {
                    Logger.exception((String)EventDetailsFragment.class.getSimpleName(), (Exception)e);
                }
            }
        });
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        switch (requestCode) {
            case 13: {
                if (grantResults.length <= 0 || grantResults[0] != 0) break;
                this.makePhoneCall();
            }
        }
    }

    private void makePhoneCall() {
        if (ContextCompat.checkSelfPermission((Context)this.getActivity(), (String)"android.permission.CALL_PHONE") != 0) {
            return;
        }
        Intent intent = new Intent("android.intent.action.DIAL");
        intent.setData(Uri.parse((String)String.format(Locale.getDefault(), "tel:%s", this.event.phoneNumber)));
        this.getActivity().startActivity(intent);
    }
}

