/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.models;

import android.content.Context;
import android.graphics.PorterDuff;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.content.ContextCompat;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.flybits.android.kernel.models.LocalizedValue;
import com.flybits.commons.library.logging.Logger;
import com.flybits.concierge.R;
import com.flybits.concierge.Utils;
import com.flybits.concierge.models.BaseTemplate;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;

public class ScheduleSegment
extends BaseTemplate {
    public LocalizedValue title;
    public String url;
    public String startTime;
    public String endTime;
    public LocalizedValue description;
    private static Calendar today = Calendar.getInstance();
    private Date startDayTime;
    private Date endDayTime;
    public static final Parcelable.Creator<ScheduleSegment> CREATOR = new Parcelable.Creator<ScheduleSegment>(){

        public ScheduleSegment createFromParcel(Parcel in) {
            return new ScheduleSegment(in);
        }

        public ScheduleSegment[] newArray(int size) {
            return new ScheduleSegment[size];
        }
    };

    public ScheduleSegment() {
    }

    protected ScheduleSegment(Parcel in) {
        super(in);
        this.title = (LocalizedValue)in.readParcelable(LocalizedValue.class.getClassLoader());
        this.url = in.readString();
        this.startTime = in.readString();
        this.endTime = in.readString();
        this.description = (LocalizedValue)in.readParcelable(LocalizedValue.class.getClassLoader());
    }

    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeParcelable((Parcelable)this.title, flags);
        dest.writeString(this.url);
        dest.writeString(this.startTime);
        dest.writeString(this.endTime);
        dest.writeParcelable((Parcelable)this.description, flags);
    }

    public Date getStartDayTime() {
        if (this.startDayTime != null) {
            return this.startDayTime;
        }
        try {
            Calendar calendar = Utils.toCalendar(this.startTime);
            calendar.set(6, today.get(6));
            this.startDayTime = calendar.getTime();
        }
        catch (ParseException e) {
            Logger.exception((String)ScheduleSegment.class.getSimpleName(), (Exception)e);
        }
        return this.startDayTime;
    }

    public Date getEndDayTime() {
        if (this.endDayTime != null) {
            return this.endDayTime;
        }
        try {
            Calendar calendar = Utils.toCalendar(this.endTime);
            calendar.set(6, today.get(6));
            this.endDayTime = calendar.getTime();
        }
        catch (ParseException e) {
            Logger.exception((String)ScheduleSegment.class.getSimpleName(), (Exception)e);
        }
        return this.endDayTime;
    }

    public void populateViews(TextView timeRangeView, TextView titleView, TextView descriptionView, ImageView bulletOutView, ImageView bulletInView, View containerView) {
        String range = Utils.getTimeRange(this.getStartDayTime(), this.getEndDayTime());
        timeRangeView.setText((CharSequence)range);
        titleView.setText((CharSequence)this.title.getValue());
        descriptionView.setText((CharSequence)this.description.getValue());
        boolean isCurrent = today.getTime().after(this.startDayTime) && today.getTime().before(this.endDayTime);
        boolean isPast = today.getTime().after(this.endDayTime);
        bulletOutView.setColorFilter(ContextCompat.getColor((Context)bulletOutView.getContext(), (int)(isCurrent ? R.color.flybits_con_schedule_bullet_out_selected : R.color.flybits_con_schedule_bullet_out)), PorterDuff.Mode.MULTIPLY);
        bulletInView.setColorFilter(ContextCompat.getColor((Context)bulletInView.getContext(), (int)(isCurrent ? R.color.flybits_con_schedule_bullet_in_selected : R.color.flybits_con_schedule_bullet_in)), PorterDuff.Mode.MULTIPLY);
        containerView.setBackgroundColor(ContextCompat.getColor((Context)containerView.getContext(), (int)(isPast ? R.color.flybits_con_schedule_segment_item_background_past : (isCurrent ? R.color.flybits_con_schedule_segment_item_background_selected : R.color.flybits_con_schedule_segment_item_background))));
        int textColor = ContextCompat.getColor((Context)titleView.getContext(), (int)(isCurrent ? R.color.flybits_white : R.color.flybits_con_body_text_color));
        timeRangeView.setTextColor(textColor);
        titleView.setTextColor(textColor);
        descriptionView.setTextColor(textColor);
    }
}

