package com.flybits.concierge.viewholders;

import android.view.View;
import android.widget.ImageView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.request.RequestOptions;
import com.flybits.concierge.ConciergeFragment;
import com.flybits.concierge.FlybitsNavigator;
import com.flybits.concierge.R;
import com.flybits.concierge.models.Image;
import com.flybits.concierge.models.Images;

public class ImageViewHolder extends FlybitsViewHolder<Images> implements View.OnClickListener
{
    private View thisView;
    private ImageView singleView;
    private View doubleView;
    private View multipleView;

    private ImageView[] doubleImages;
    private ImageView[] multipleImages;

    private ConciergeFragment conciergeFragment;

    private Images currentBoundImage;

    public ImageViewHolder(ConciergeFragment conciergeFragment, View itemView)
    {
        super(itemView);
        this.conciergeFragment = conciergeFragment;
        this.thisView = itemView;

        singleView = itemView.findViewById(R.id.flybits_con_item_image_imgSingle);

        doubleImages = new ImageView[] {
                itemView.findViewById(R.id.flybits_con_item_image_imgDoubleLeft),
                itemView.findViewById(R.id.flybits_con_item_image_imgDoubleRight)
        };

        multipleImages = new ImageView[] {
                itemView.findViewById(R.id.flybits_con_item_image_imgBig),
                itemView.findViewById(R.id.flybits_con_item_image_imgTR),
                itemView.findViewById(R.id.flybits_con_item_image_imgBR)
        };

        doubleView = itemView.findViewById(R.id.flybits_con_item_image_lytDouble);
        multipleView = itemView.findViewById(R.id.flybits_con_item_image_lytTriple);
    }

    @Override
    public void bindData(final Images images, FlybitsNavigator flybitsNavigator)
    {
        currentBoundImage = images;

        ImageView[] imageViews;

        singleView.setVisibility(View.GONE);
        doubleView.setVisibility(View.GONE);
        multipleView.setVisibility(View.GONE);

        RequestOptions options = new RequestOptions().centerCrop().format(DecodeFormat.PREFER_RGB_565);

        if (images.images.getList().size() == 1)
        {
            Image image = images.images.getList().get(0);
            singleView.setVisibility(View.VISIBLE);

            Glide.with(thisView.getContext())
                    .load(image.url)
                    .apply(options)
                    .into(singleView);
            singleView.setOnClickListener(this);

            return;
        }
        else
        {
            switch (images.images.getList().size())
            {
                default:
                    imageViews = multipleImages;
                    multipleView.setVisibility(View.VISIBLE);
                    break;
                case 2:
                    imageViews = doubleImages;
                    doubleView.setVisibility(View.VISIBLE);
                    break;
            }
        }

        for (int i = 0; i < imageViews.length; i++)
        {
            ImageView imgView = imageViews[i];
            Glide.with(thisView.getContext())
                    .load(images.images.getList().get(i).url)
                    .apply(options)
                    .into(imgView);
            imgView.setOnClickListener(this);
        }
    }

    @Override
    public void onClick(View view)
    {
        if (view.equals(singleView))
        {
            conciergeFragment.openImageViewer(currentBoundImage.images, 0);
        }
        else
        {
            for (int i = 0; i < multipleImages.length; i++)
            {
                if ((i < doubleImages.length && view.equals(doubleImages[i])) || view.equals(multipleImages[i]))
                {
                    conciergeFragment.openImageViewer(currentBoundImage.images, i);
                    break;
                }
            }
        }
    }
}
