package com.flybits.concierge.models;

import android.os.Parcel;
import android.os.Parcelable;

import com.flybits.android.kernel.models.PagedArray;
import com.flybits.concierge.enums.ScheduleDay;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Schedule extends BaseTemplate
{
    private Map<String, LinkedList<ScheduleSegment>> weekdays;

    public Schedule()
    {
    }

    public PagedArray<ScheduleDaily> schedule;

    protected Schedule(Parcel in)
    {
        super(in);
        schedule = in.readParcelable(PagedArray.class.getClassLoader());
    }

    public static final Creator<Schedule> CREATOR = new Creator<Schedule>()
    {
        @Override
        public Schedule createFromParcel(Parcel in)
        {
            return new Schedule(in);
        }

        @Override
        public Schedule[] newArray(int size)
        {
            return new Schedule[size];
        }
    };

    @Override
    public int describeContents()
    {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags)
    {
        super.writeToParcel(dest,flags);
        dest.writeParcelable(schedule, flags);
    }

    public Map<String, LinkedList<ScheduleSegment>> generateSegmentList()
    {
        if (weekdays != null)
        {
            return weekdays;
        }

        weekdays = new HashMap<>();

        weekdays.put(ScheduleDay.SUNDAY.getText(), new LinkedList<ScheduleSegment>());
        weekdays.put(ScheduleDay.MONDAY.getText(), new LinkedList<ScheduleSegment>());
        weekdays.put(ScheduleDay.TUESDAY.getText(), new LinkedList<ScheduleSegment>());
        weekdays.put(ScheduleDay.WEDNESDAY.getText(), new LinkedList<ScheduleSegment>());
        weekdays.put(ScheduleDay.THURSDAY.getText(), new LinkedList<ScheduleSegment>());
        weekdays.put(ScheduleDay.FRIDAY.getText(), new LinkedList<ScheduleSegment>());
        weekdays.put(ScheduleDay.SATURDAY.getText(), new LinkedList<ScheduleSegment>());

        for (ScheduleDaily daily : schedule.getList())
        {
            for (ScheduleSegment scheduleSegment : daily.segmentDetails)
            {
                switch (daily.getScheduleDay())
                {
                    case UNKNOWN:
                        // Skip
                        break;
                    case WEEKDAY:
                        // Put into Monday -> Friday
                        weekdays.get(ScheduleDay.MONDAY.getText())
                                .add(scheduleSegment);
                        weekdays.get(ScheduleDay.TUESDAY.getText())
                                .add(scheduleSegment);
                        weekdays.get(ScheduleDay.WEDNESDAY.getText())
                                .add(scheduleSegment);
                        weekdays.get(ScheduleDay.TUESDAY.getText())
                                .add(scheduleSegment);
                        weekdays.get(ScheduleDay.FRIDAY.getText())
                                .add(scheduleSegment);
                        break;
                    case WEEKEND:
                        // Put into Saturday -> Sunday
                        weekdays.get(ScheduleDay.SATURDAY.getText())
                                .add(scheduleSegment);
                        weekdays.get(ScheduleDay.SUNDAY.getText())
                                .add(scheduleSegment);
                        break;
                    case EVERYDAY:
                        // Put in Monday -> Sun
                        weekdays.get(ScheduleDay.MONDAY.getText())
                                .add(scheduleSegment);
                        weekdays.get(ScheduleDay.TUESDAY.getText())
                                .add(scheduleSegment);
                        weekdays.get(ScheduleDay.WEDNESDAY.getText())
                                .add(scheduleSegment);
                        weekdays.get(ScheduleDay.TUESDAY.getText())
                                .add(scheduleSegment);
                        weekdays.get(ScheduleDay.FRIDAY.getText())
                                .add(scheduleSegment);
                        weekdays.get(ScheduleDay.SATURDAY.getText())
                                .add(scheduleSegment);
                        weekdays.get(ScheduleDay.SUNDAY.getText())
                                .add(scheduleSegment);
                        break;
                    default:
                        weekdays.get(daily.dayOfTheWeek)
                                .add(scheduleSegment);
                        break;
                }
            }
        }

        // clean up
        Set<String> keys = weekdays.keySet();
        List<String> markedForDeletion = new ArrayList<>();

        for (String key : keys)
        {
            LinkedList<ScheduleSegment> segments = weekdays.get(key);

            if (segments.size() != 0)
            {
                Collections.sort(segments, new Comparator<ScheduleSegment>()
                {
                    @Override
                    public int compare(ScheduleSegment left, ScheduleSegment right)
                    {
                        return left.getStartDayTime().compareTo(right.getStartDayTime());
                    }
                });
            }
            else
            {
                // remove so there isn't an additional element here
                markedForDeletion.add(key);
            }
        }

        for (String day : markedForDeletion)
        {
            weekdays.remove(day);
        }

        return weekdays;
    }
}
