package com.flybits.concierge.viewproviders

import android.view.LayoutInflater
import android.view.ViewGroup
import com.flybits.concierge.*
import com.flybits.concierge.ConciergeConstants.SCHEDULE_CONTENT_TYPE
import com.flybits.concierge.fragments.ScheduleFeedFragment
import com.flybits.concierge.models.Schedule
import com.flybits.concierge.viewholders.FlybitsViewHolder
import com.flybits.concierge.viewholders.ScheduleViewHolder

class ScheduleViewProvider: FlybitsViewProvider<Schedule> {

    override fun getClassType() = Schedule::class.java

    override fun getContentType() = SCHEDULE_CONTENT_TYPE

    override fun onCreateViewHolder(parent: ViewGroup): FlybitsViewHolder<Schedule> {
        return ScheduleViewHolder(LayoutInflater.from(parent.context).inflate(R.layout.flybits_con_item_template_schedule, parent, false))
    }

    override fun onPushOpened(model: Schedule, flybitsNavigator: FlybitsNavigator) {
        flybitsNavigator.openFragment(ScheduleFeedFragment.newInstance(model))
    }
}