/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.views;

import android.app.FragmentManager;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import com.flybits.concierge.R;
import com.flybits.concierge.Utils;
import com.flybits.concierge.views.SurveyBaseView;
import com.wdullaer.materialdatetimepicker.time.TimePickerDialog;
import java.util.Calendar;

public class SurveyTime
extends SurveyBaseView
implements TimePickerDialog.OnTimeSetListener {
    private static final String DIALOG_TIME_PICKER = "flybits_con_dialog_time_picker";
    private Button selectButton;
    private Calendar selectedTime;
    private FragmentManager fragmentManager;

    public SurveyTime(Context context, FragmentManager fragmentManager, Calendar calendar) {
        super(context);
        this.fragmentManager = fragmentManager;
        this.selectedTime = calendar;
        this.init(null, 0);
    }

    public SurveyTime(Context context) {
        super(context);
        this.init(null, 0);
    }

    public SurveyTime(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public SurveyTime(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs, defStyle);
    }

    private void init(AttributeSet attrs, int defStyle) {
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.flybits_con_view_survey_time, (ViewGroup)this, true);
        this.selectButton = (Button)view.findViewById(R.id.flybits_con_view_survey_time_btnTime);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.selectedTime != null) {
            this.selectButton.setText((CharSequence)Utils.getTimeString(this.selectedTime.getTime()));
        }
        this.selectButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Calendar displayedTime = SurveyTime.this.selectedTime != null ? SurveyTime.this.selectedTime : Calendar.getInstance();
                TimePickerDialog dialog = TimePickerDialog.newInstance((TimePickerDialog.OnTimeSetListener)SurveyTime.this, (int)displayedTime.get(11), (int)displayedTime.get(12), (boolean)false);
                dialog.show(SurveyTime.this.fragmentManager, SurveyTime.DIALOG_TIME_PICKER);
            }
        });
    }

    public void onTimeSet(TimePickerDialog view, int hourOfDay, int minute, int second) {
        this.selectedTime = Calendar.getInstance();
        this.selectedTime.set(11, hourOfDay);
        this.selectedTime.set(12, minute);
        this.selectButton.setText((CharSequence)Utils.getTimeString(this.selectedTime.getTime()));
        this.callOnClick();
    }

    @Override
    public Object getAnswer() {
        return this.selectedTime;
    }
}

