package com.flybits.concierge.viewproviders

import android.view.LayoutInflater
import android.view.ViewGroup
import com.flybits.concierge.*
import com.flybits.concierge.models.Audios
import com.flybits.concierge.viewholders.AudiosViewHolder

class AudiosViewProvider(private val conciergeFragment: ConciergeFragment): FlybitsViewProvider<Audios> {

    override fun getClassType() = Audios::class.java

    override fun getContentType() = ConciergeConstants.AUDIO_CONTENT_TYPE

    override fun onCreateViewHolder(parent: ViewGroup): AudiosViewHolder{
        val view = LayoutInflater.from(parent.context).inflate(R.layout.flybits_con_item_template_audios, parent, false)
        return AudiosViewHolder(conciergeFragment, view)
    }

    override fun onPushOpened(model: Audios, flybitsNavigator: FlybitsNavigator) {
    }
}