/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.viewholders;

import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.flybits.concierge.FlybitsNavigator;
import com.flybits.concierge.R;
import com.flybits.concierge.adapters.ArticleAdapter;
import com.flybits.concierge.models.Article;
import com.flybits.concierge.models.Articles;
import com.flybits.concierge.viewholders.FlybitsViewHolder;
import java.util.ArrayList;

public class ArticlesViewHolder
extends FlybitsViewHolder<Articles> {
    private ViewPager viewPager;
    private View singleView;
    private ImageView imgHeader;
    private TextView txtTitle;
    private TextView txtSource;
    private TextView txtDescription;
    private View thisView;

    public ArticlesViewHolder(View itemView) {
        super(itemView);
        this.viewPager = (ViewPager)itemView.findViewById(R.id.flybits_con_articles_viewPager);
        this.singleView = itemView.findViewById(R.id.flybits_con_articles_single);
        this.thisView = itemView;
        this.imgHeader = (ImageView)itemView.findViewById(R.id.flybits_con_article_imgHeader);
        this.txtTitle = (TextView)itemView.findViewById(R.id.flybits_con_article_txtTitle);
        this.txtSource = (TextView)itemView.findViewById(R.id.flybits_con_article_txtSource);
        this.txtDescription = (TextView)itemView.findViewById(R.id.flybits_con_article_txtDescription);
        this.viewPager.setClipToPadding(false);
        this.viewPager.setPadding(50, 0, 50, 0);
        this.viewPager.setPageMargin(5);
    }

    @Override
    public void bindData(Articles data, FlybitsNavigator flybitsNavigator) {
        this.viewPager.setVisibility(8);
        this.singleView.setVisibility(8);
        ArrayList articleList = data.articles.getList();
        if (articleList.size() > 1) {
            this.viewPager.setVisibility(0);
            ArticleAdapter adapter = new ArticleAdapter();
            this.viewPager.setAdapter((PagerAdapter)adapter);
            adapter.setData(data.articles.getList());
        } else if (articleList.size() == 1) {
            this.singleView.setVisibility(0);
            ((Article)articleList.get(0)).populateViews(this.imgHeader, this.txtTitle, this.txtSource, this.txtDescription, this.thisView);
        }
    }

    public void setPagerId(int position) {
        this.viewPager.setId(position);
    }
}

