/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.models;

import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.request.RequestOptions;
import com.flybits.android.kernel.models.LocalizedValue;
import com.flybits.commons.library.logging.Logger;
import com.flybits.concierge.FlybitsNavigator;
import com.flybits.concierge.Utils;
import com.flybits.concierge.activities.YouTubePlayerActivity;
import com.flybits.concierge.fragments.VideoFragment;
import com.flybits.concierge.models.BaseTemplate;
import java.net.URL;
import java.util.Map;

public class Video
extends BaseTemplate
implements Parcelable {
    public LocalizedValue title;
    public String url;
    public String duration;
    public String imageURL;
    public static final Parcelable.Creator<Video> CREATOR = new Parcelable.Creator<Video>(){

        public Video createFromParcel(Parcel in) {
            return new Video(in);
        }

        public Video[] newArray(int size) {
            return new Video[size];
        }
    };

    public Video() {
    }

    protected Video(Parcel in) {
        this.title = (LocalizedValue)in.readParcelable(LocalizedValue.class.getClassLoader());
        this.url = in.readString();
        this.duration = in.readString();
        this.imageURL = in.readString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.title, flags);
        dest.writeString(this.url);
        dest.writeString(this.duration);
        dest.writeString(this.imageURL);
    }

    public void populateViews(FlybitsNavigator flybitsNavigator, ImageView placeholderImageView, View callToActionView) {
        this.populateViews(flybitsNavigator, null, null, placeholderImageView, callToActionView);
    }

    public void populateViews(final FlybitsNavigator fragmentSwitcher, TextView titleTextView, TextView durationTextView, ImageView placeholderImageView, View callToActionView) {
        if (titleTextView != null) {
            titleTextView.setText((CharSequence)this.title.getValue());
        }
        if (durationTextView != null) {
            durationTextView.setVisibility(!TextUtils.isEmpty((CharSequence)this.duration) ? 0 : 4);
            durationTextView.setText((CharSequence)this.duration);
        }
        RequestOptions options = new RequestOptions().format(DecodeFormat.PREFER_RGB_565);
        Glide.with((Context)placeholderImageView.getContext()).load(this.imageURL).apply(options).into(placeholderImageView);
        callToActionView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                try {
                    URL videoUrl = new URL(Video.this.url);
                    videoUrl.getHost();
                    String videoId = null;
                    switch (videoUrl.getHost()) {
                        case "www.youtube.com": {
                            Map<String, String> map = Utils.splitQuery(videoUrl);
                            videoId = map.get("v");
                            break;
                        }
                        case "youtu.be": {
                            String path = videoUrl.getPath();
                            if (TextUtils.isEmpty((CharSequence)path) || path.length() <= 2) break;
                            videoId = videoUrl.getPath().substring(1);
                        }
                    }
                    if (!TextUtils.isEmpty(videoId)) {
                        Video.this.watchYoutubeVideo(v.getContext(), videoId);
                        return;
                    }
                }
                catch (Exception e) {
                    Logger.exception((String)Video.class.getSimpleName(), (Exception)e);
                }
                VideoFragment fragment = VideoFragment.newInstance(Video.this);
                fragmentSwitcher.openFragment(fragment);
            }
        });
    }

    private void watchYoutubeVideo(Context context, String id2) {
        Intent intent = new Intent(context, YouTubePlayerActivity.class);
        intent.putExtra("flybits_con_arg_youtubeid", id2);
        context.startActivity(intent);
    }
}

