/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.models;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.request.RequestOptions;
import com.flybits.android.kernel.models.LocalizedValue;
import com.flybits.concierge.models.BaseTemplate;

public class Article
extends BaseTemplate
implements Parcelable {
    public LocalizedValue title;
    public LocalizedValue description;
    public String imageURL;
    public String sourceName;
    public String url;
    public static final Parcelable.Creator<Article> CREATOR = new Parcelable.Creator<Article>(){

        public Article createFromParcel(Parcel in) {
            return new Article(in);
        }

        public Article[] newArray(int size) {
            return new Article[size];
        }
    };

    public Article() {
    }

    protected Article(Parcel in) {
        this.title = (LocalizedValue)in.readParcelable(LocalizedValue.class.getClassLoader());
        this.description = (LocalizedValue)in.readParcelable(LocalizedValue.class.getClassLoader());
        this.imageURL = in.readString();
        this.sourceName = in.readString();
        this.url = in.readString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.title, flags);
        dest.writeParcelable((Parcelable)this.description, flags);
        dest.writeString(this.imageURL);
        dest.writeString(this.sourceName);
        dest.writeString(this.url);
    }

    public void populateViews(ImageView headerView, TextView titleView, TextView sourceView, TextView descriptionView, View openLinkView) {
        RequestOptions options = new RequestOptions().format(DecodeFormat.PREFER_RGB_565);
        Glide.with((Context)headerView.getContext()).load(this.imageURL).apply(options).into(headerView);
        titleView.setText((CharSequence)this.title.getValue());
        sourceView.setVisibility(!TextUtils.isEmpty((CharSequence)this.sourceName) ? 0 : 4);
        sourceView.setText((CharSequence)this.sourceName);
        descriptionView.setText((CharSequence)this.description.getValue());
        openLinkView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String url = Article.this.url;
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setData(Uri.parse((String)url));
                v.getContext().startActivity(intent);
            }
        });
    }
}

