/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.fragments;

import android.app.Activity;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.Observer;
import android.arch.lifecycle.ViewModelProviders;
import android.arch.paging.PagedList;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.design.widget.Snackbar;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.afollestad.materialdialogs.MaterialDialog;
import com.flybits.android.kernel.models.Content;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import com.flybits.concierge.ConciergeFragment;
import com.flybits.concierge.FlybitsNavigator;
import com.flybits.concierge.FlybitsViewProvider;
import com.flybits.concierge.FlybitsViewProviderGetter;
import com.flybits.concierge.R;
import com.flybits.concierge.activities.ConciergeActivity;
import com.flybits.concierge.activities.ConciergePopupActivity;
import com.flybits.concierge.adapters.FeedAdapter;
import com.flybits.concierge.fragments.BasePagerFragment;
import com.flybits.concierge.models.BaseTemplate;
import com.flybits.concierge.viewmodels.FeedViewModel;
import com.flybits.concierge.viewmodels.TwitterViewModel;

public class FeedFragment
extends BasePagerFragment
implements FeedViewModel.FeedErrorDisplayer {
    private RecyclerView recyclerView;
    private FeedViewModel feedViewModel;
    private FeedAdapter feedAdapter;
    private View noDataView;
    private BroadcastReceiver refreshReceiver;
    private SwipeRefreshLayout swipeRefreshLayout;

    public static FeedFragment newInstance() {
        FeedFragment fragment = new FeedFragment();
        return fragment;
    }

    @Override
    public int titleRes() {
        return R.string.flybits_con_fragment_title_feed;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.flybits_con_fragment_feed, container, false);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        view.findViewById(R.id.flybits_con_fragment_feed_settings_button).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Fragment parentFragment = FeedFragment.this.getParentFragment();
                if (parentFragment != null && parentFragment instanceof ConciergeFragment) {
                    ((ConciergeFragment)parentFragment).startSettingsActivity();
                }
            }
        });
        this.recyclerView = (RecyclerView)view.findViewById(R.id.flybits_con_fragment_feed_lytRecycler);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        ConciergeFragment conciergeFragment = (ConciergeFragment)this.getParentFragment();
        this.feedAdapter = new FeedAdapter(conciergeFragment, conciergeFragment);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.feedAdapter);
        this.recyclerView.setHasFixedSize(false);
        this.swipeRefreshLayout = (SwipeRefreshLayout)view.findViewById(R.id.flybits_con_swipe_ref_layout);
        this.swipeRefreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                Logger.d((String)(FeedFragment.class.getSimpleName() + ": onRefresh()"));
                FeedFragment.this.swipeRefreshLayout.setEnabled(false);
                FeedFragment.this.feedViewModel.refresh(new FeedViewModel.RefreshResultListener(){

                    @Override
                    public void onFinished() {
                        FeedFragment.this.swipeRefreshLayout.setEnabled(true);
                        FeedFragment.this.swipeRefreshLayout.setRefreshing(false);
                    }
                });
                if (FeedFragment.this.getContext() != null) {
                    TwitterViewModel twitterViewModel = (TwitterViewModel)ViewModelProviders.of((FragmentActivity)((FragmentActivity)FeedFragment.this.getContext())).get(TwitterViewModel.class);
                    twitterViewModel.clearTweetLists();
                }
            }
        });
        this.noDataView = view.findViewById(R.id.flybits_con_fragment_feed_lytNoData);
        this.feedViewModel = (FeedViewModel)ViewModelProviders.of((Fragment)this).get(FeedViewModel.class);
        this.swipeRefreshLayout.setRefreshing(true);
        this.feedViewModel.getFeedContent().observe((LifecycleOwner)this, (Observer)new Observer<PagedList<BaseTemplate>>(){

            public void onChanged(@Nullable PagedList<BaseTemplate> baseTemplates) {
                Logger.d((String)("Got data! data: " + baseTemplates));
                FeedFragment.this.feedAdapter.submitList(baseTemplates);
                boolean baseTemplatesEmpty = baseTemplates.isEmpty();
                FeedFragment.this.recyclerView.setVisibility(baseTemplatesEmpty ? 8 : 0);
                FeedFragment.this.noDataView.setVisibility(baseTemplatesEmpty ? 0 : 8);
                FeedFragment.this.swipeRefreshLayout.setRefreshing(false);
            }
        });
        this.feedViewModel.setFeedErrorDisplayer(this);
        this.refreshReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (FeedFragment.this.feedAdapter != null) {
                    try {
                        FeedFragment.this.feedAdapter.notifyDataSetChanged();
                    }
                    catch (Exception e) {
                        Logger.exception((String)"FeedFragment.RefreshReceiver.onReceiver()", (Exception)e);
                    }
                }
            }
        };
        FragmentActivity activity = this.getActivity();
        String metaDataId = activity.getIntent().getStringExtra("flybits_con_push_content_id");
        String url = activity.getIntent().getStringExtra("flybits_con_push_content_url");
        if (metaDataId != null) {
            this.feedViewModel.connectAndDownLoad((Activity)activity, metaDataId, new ObjectResultCallback<Content>(){

                public void onSuccess(Content item) {
                    Fragment conciergeFragment = FeedFragment.this.getParentFragment();
                    if (conciergeFragment != null) {
                        BaseTemplate baseTemplate;
                        FlybitsViewProviderGetter flybitsViewProviderGetter = (FlybitsViewProviderGetter)conciergeFragment;
                        FlybitsNavigator flybitsNavigator = (FlybitsNavigator)conciergeFragment;
                        FlybitsViewProvider flybitsViewProvider = flybitsViewProviderGetter.getFlybitsViewProvider(item.getType());
                        if (flybitsViewProvider != null && (baseTemplate = BaseTemplate.fromContent(flybitsViewProvider.getClassType(), item, FeedFragment.this.getContext())) != null) {
                            flybitsViewProvider.onPushOpened(baseTemplate, flybitsNavigator);
                        }
                    }
                }

                public void onException(FlybitsException e) {
                    FragmentActivity currentActivity = FeedFragment.this.getActivity();
                    if (currentActivity != null) {
                        new MaterialDialog.Builder((Context)currentActivity).title(R.string.flybits_con_error).content(R.string.flybits_con_could_not_load).positiveText(17039370).dismissListener(new DialogInterface.OnDismissListener((Activity)currentActivity){
                            final /* synthetic */ Activity val$currentActivity;
                            {
                                this.val$currentActivity = activity;
                            }

                            public void onDismiss(DialogInterface dialog) {
                                this.val$currentActivity.finish();
                            }
                        }).show();
                    }
                    Logger.exception((String)FeedFragment.class.getSimpleName(), (Exception)e);
                }
            });
        } else if (url != null) {
            ((FlybitsNavigator)this.getParentFragment()).openUrl(url);
        }
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            FragmentActivity activity = this.getActivity();
            if (activity != null) {
                activity.registerReceiver(this.refreshReceiver, new IntentFilter("flybits_con_broadcast_audio_state"));
            }
        }
        catch (Exception e) {
            Logger.exception((String)"FeedFragment.onCreate()", (Exception)e);
        }
    }

    public void onDestroy() {
        super.onDestroy();
        try {
            FragmentActivity activity = this.getActivity();
            if (activity != null) {
                activity.unregisterReceiver(this.refreshReceiver);
            }
        }
        catch (Exception e) {
            Logger.exception((String)"FeedFragment.onDestroy()", (Exception)e);
        }
    }

    @Override
    public void onError(String err) {
        Logger.d((String)("FeedFragment: onAuthenticationError() err: " + err));
        FragmentActivity activity = this.getActivity();
        View v = this.getView();
        if (activity != null && (activity instanceof ConciergeActivity || activity instanceof ConciergePopupActivity) && v != null) {
            Snackbar.make((View)v, (CharSequence)err, (int)0).show();
        }
    }
}

