package com.flybits.concierge.models;

import android.os.Parcel;
import android.os.Parcelable;

import com.flybits.android.kernel.models.LocalizedValue;

public class Image extends BaseTemplate implements Parcelable
{
    public LocalizedValue title;
    public LocalizedValue caption;
    public String url;

    public Image()
    {
    }

    protected Image(Parcel in)
    {
        title = in.readParcelable(LocalizedValue.class.getClassLoader());
        caption = in.readParcelable(LocalizedValue.class.getClassLoader());
        url = in.readString();
    }

    public static final Creator<Image> CREATOR = new Creator<Image>()
    {
        @Override
        public Image createFromParcel(Parcel in)
        {
            return new Image(in);
        }

        @Override
        public Image[] newArray(int size)
        {
            return new Image[size];
        }
    };

    @Override
    public int describeContents()
    {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags)
    {
        dest.writeParcelable(title, flags);
        dest.writeParcelable(caption, flags);
        dest.writeString(url);
    }
}
