package com.flybits.concierge.models;

import android.content.Context;

import com.flybits.android.kernel.models.Content;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import com.flybits.concierge.FlybitsViewProvider;
import com.flybits.concierge.FlybitsViewProviderGetter;

import java.util.Locale;

public abstract class BaseTemplate
{

    public static BaseTemplate fromContent(FlybitsViewProviderGetter flybitsViewProviderGetter, Content content, Context context) {

        FlybitsViewProvider flybitsViewProvider = flybitsViewProviderGetter.getFlybitsViewProvider(content.getType());

        if (flybitsViewProvider == null) return null;

        Class typeClass = flybitsViewProvider.getClassType();

        return fromContent(typeClass, content, context);
    }

    public static BaseTemplate fromContent(Class typeClass, Content content, Context context){
        try
        {
            BaseTemplate contentObject = content.getData(context, typeClass);
            if (contentObject != null){
                contentObject.setContent(content);
                return contentObject;
            }
        }
        catch (FlybitsException e)
        {
            Logger.d(String.format(Locale.getDefault(), "Developer: Invalid Template Found: %s", content.getType()));
            Logger.exception(BaseTemplate.class.getSimpleName(), e);
        }

        return null;
    }

    private Content content;

    @Override
    public final String toString()
    {
        return getClass().getSimpleName();
    }

    public Content getContent()
    {
        return content;
    }

    public void setContent(Content content)
    {
        this.content = content;
    }

}
